#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Fru
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.Ipsec" )
t0 = Tracing.trace0

class IpsecDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::Ipsec"

   def __init__( self, invIpsec, parentMib, parentDriver, driverCtx ):
      t0( "Handling Inventory::Ipsec for %s" % Fru.fruBaseName( invIpsec ) )
      Fru.FruDriver.__init__( self, invIpsec, parentMib, parentDriver, driverCtx )

      fruBase = Fru.fruBase( invIpsec )
      ipsecName = fruBase.sliceId

      lcDir = driverCtx.sysdbRoot[ 'cell' ][ str( Cell.cellId() ) ][ 'hardware' ][
            'ipsec' ][ 'launcherConfig' ]
      lcDir.newEntity( "Tac::Dir", ipsecName )
      t0( "Instantiated '%s' entity in Ipsec's launcherConfig dir", ipsecName )

def Plugin( context ):
   context.registerDriver( IpsecDriver )
   mg = context.entityManager.mountGroup()
   mg.mount( 'cell/%s/hardware/ipsec/launcherConfig' % Cell.cellId(), 'Tac::Dir',
             'wi' )
   mg.close( None )
