# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import os
import Tac

sourceConfig = None
def registerHealthSource( entity, name ):
   if "A4_CHROOT" in os.environ and not sourceConfig:
      return
   assert sourceConfig
   # If you hit this assert, make sure registered name is valid.
   # For e.g. FRU name ("Chassis", "FixedSystem", slotName, etc),
   # ASIC name (e.g. "Jericho4/0", "Linecard0/0", etc), Interface name, etc.
   assert name, "%s registered with invalid name '%s'" % ( entity.fullName, name )
   fruBase = Fru.fruBase( entity )
   if fruBase is None:
      assert name == "Root"
      genId = 1
   else:
      genId = Fru.fruBase( entity ).generationId
   Fru.Dep( sourceConfig.sourceName, entity )[ entity.fullName ] = name
   parentSrcName = sourceConfig.parentSource( entity.fullName )
   Fru.Dep( sourceConfig.parentEdge, entity )[ name ] = \
      Tac.Value( "Health::SourceParentEdge", name, parentSrcName, genId )

def Plugin( context ):
   global sourceConfig
   mg = context.entityManager.mountGroup()
   sourceConfig = mg.mount( 'health/source', 'Health::SourceConfig', 'w' )
   mg.close( None )
