#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Tracing

t0 = Tracing.trace0

class ScdExternalAlarmBlockDriver( Fru.FruDriver ):

   managedTypeName = "Inventory::PciScd"
   primaryDriver = False

   def __init__( self, scd, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, scd, parentMibEntity, parentDriver, driverCtx )

      t0( "ScdExternalAlarmBlockDriver w/ external alarm block:",
          scd.externalAlarmBlock )

      if not scd.externalAlarmBlock or scd.externalAlarmCount == 0:
         # External alarms not supported on platform, nothing to do
         return

      hwDir = driverCtx.sysdbRoot[ 'hardware' ]
      if 'externalAlarm' not in hwDir:
         hwDir.mkDir( 'externalAlarm' )
      hwExternalAlarm = hwDir[ 'externalAlarm' ]

      if 'config' not in hwExternalAlarm:
         hwExternalAlarm.newEntity( "Hardware::ExternalAlarm::Config", 'config' )
      config = hwExternalAlarm[ 'config' ]
      config.maxAlarms = scd.externalAlarmCount
      config.blockOffset = scd.externalAlarmBlock.offset

def Plugin( context ):
   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/externalAlarm/config',
             'Hardware::ExternalAlarm::Config', 'w' )
   mg.close( None )
   context.registerDriver( ScdExternalAlarmBlockDriver )
