# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Logging

FRU_SYSTEM_DEPRECATED = None
FRU_SYSTEM_UNSUPPORTED = None
FRU_MODULE_DEPRECATED = None
Logging.logD( id="FRU_SYSTEM_DEPRECATED",
              severity=Logging.logEmergency,
              format="%s is not supported."
              " The last supported EOS version for this system is %s",
              explanation="The current hardware has been deprecated and"
              " is not supported by the running software."
              " System functionality is severely limited.",
              recommendedAction="Install older software and reboot" )
Logging.logD( id="FRU_SYSTEM_UNSUPPORTED",
              severity=Logging.logEmergency,
              format="%s is not supported.",
              explanation="The current hardware is not supported"
              " by the running software."
              " System functionality is severely limited.",
              recommendedAction="Install software supporting the hardware"
              " and reboot" )
Logging.logD( id="FRU_MODULE_DEPRECATED",
              severity=Logging.logEmergency,
              format="Module %s%s: %s is not supported."
              " The last supported EOS version for this module is %s",
              explanation="The current hardware has been deprecated and"
              " is not supported by the running software."
              " System functionality is severely limited.",
              recommendedAction="Install older software and reboot" )


class UnsupportedFruDriver( Fru.FruDriver ):

   managedTypeName = "Eos::DeprecatedFru"
  
   def __init__( self, testFru, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, testFru, parentMibEntity, parentDriver,
                              driverCtx )
      if parentMibEntity.tag == "FixedSystem":
         if testFru.name == "unsupported":
            Logging.log( FRU_SYSTEM_UNSUPPORTED, parentMibEntity.modelName )
         else:
            Logging.log( FRU_SYSTEM_DEPRECATED,
                  parentMibEntity.modelName, testFru.lastSupportedEosVersion )
      else:
         Logging.log( FRU_MODULE_DEPRECATED, parentMibEntity.tag,
               parentMibEntity.label, parentMibEntity.modelName,
               testFru.lastSupportedEosVersion )

def Plugin( context ):
   context.registerDriver( UnsupportedFruDriver )

