#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
# pylint: disable-msg=W0232

import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import dsPedPowerLossValues

class LassenDriver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"
   managedApiRe = "DeltaLassen$"

   # m, b, and R coefficients don't matter because these supplies
   # use linear encoding for everything.
   directM = 0
   directB = 0
   directR = 0
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   outputCurrentCanSignalFailure = False
   extraDelays = False
   sendByteSupported = True
   powerLossValues = dsPedPowerLossValues
   fanWarningsLenient = True
   overTempLenientDelay = 0
   # ( mfrLabel, mfrAddr, mfrLen )
   mfrData = [
      ( "MFR_ID", 0x99, None ),
      ( "MFR_MODEL", 0x9a, None ),
      ( "MFR_REVISION", 0x9b, None ),
      ( "MFR_SERIAL", 0x9e, None ),
      ( "PRI_FIRMWARE", 0xe0, 8 ),
      ( "SEC_FIRMWARE", 0xe1, 8 ),
      ( "FW_REVISION", 0xd5, 8 ),
      ( "FW_REVISION_TW", 0xef, 8 ), 
      ]

class LassenFanOperationDriver( LassenDriver ):
   managedApiRe = "DeltaLassenFanOperation$"

   fanOperation = True

class LassenPecDriver( LassenDriver ):
   managedApiRe = "DeltaLassenPec$"

   pec = True
   noOperationCmd = True

class LassenPecDualFanDriver( LassenPecDriver ):
   managedApiRe = "DeltaLassenPecDualFan$"

   dualFan = True

def Plugin( ctx ):
   ctx.registerDriver( LassenDriver )
   ctx.registerDriver( LassenFanOperationDriver )
   ctx.registerDriver( LassenPecDriver )
   ctx.registerDriver( LassenPecDualFanDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
