#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
# pylint: disable-msg=W0232

import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import dsPedPowerLossValues

class DSPedDriver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"

   # m, b, and R coefficients don't matter because these supplies
   # use linear encoding for everything.
   directM = 0
   directB = 0
   directR = 0
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   outputCurrentCanSignalFailure = False
   extraDelays = False
   sendByteSupported = True
   powerLossValues = dsPedPowerLossValues

class DS250Driver( DSPedDriver ):
   managedApiRe = "DS250"

class DS500Driver( DSPedDriver ):
   managedApiRe = "DS500"

class DS495Driver( DSPedDriver ):
   managedApiRe = "DS495"

class DS750Driver( DSPedDriver ):
   managedApiRe = "DS750"

class DS1100Driver( DSPedDriver ):
   managedApiRe = "DS1100"
   pec = True

class DS1600Driver( DSPedDriver ):
   managedApiRe = "DS1600"

class DS2400Driver( DSPedDriver ):
   managedApiRe = "DS2400"

class CSU500DP3Driver( DSPedDriver ):
   managedApiRe = "CSU500DP3"

def Plugin( ctx ):
   ctx.registerDriver( DS250Driver )
   ctx.registerDriver( DS500Driver )
   ctx.registerDriver( DS495Driver )
   ctx.registerDriver( DS750Driver )
   ctx.registerDriver( DS1100Driver )
   ctx.registerDriver( DS1600Driver )
   ctx.registerDriver( DS2400Driver )
   ctx.registerDriver( CSU500DP3Driver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
