#!/usr/bin/env python
# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
# pylint: disable-msg=W0232
# pylint: disable-msg=E1101

import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import ds460ValidRegisterValues

class DS460Driver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"

   directM = 0 # Direct MBR don't matter because DS460 does not use direct encoding
   directB = 0
   directR = 0
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingDirect11"
   overTempLenientDelay = 0

   checkRegisterValidity = False
   fanFailureAndPowerLossDifferentiator = True
   supportedRegisterValues = ds460ValidRegisterValues

   extraDelays = False
   cmlFaultsLenient = True

   def pmbusGetValidRegisterValues( self, register ):
      if register in self.supportedRegisterValues:
         return self.supportedRegisterValues[ register ]
      return None

class DS460ACBaseDriver( DS460Driver ):
   ignoreUnexpectedRegisterValues = True
   outputCurrentCanSignalFailure = True
   checkRegisterValidity = True
   fanFailureAndPowerLossDifferentiator = True
   supportedRegisterValues = ds460ValidRegisterValues

class DS460ACExtraDelaysDriver( DS460ACBaseDriver ):
   managedApiRe = "DS460-ExtraDelays"
   extraDelays = True

class DS460ACDriver( DS460ACBaseDriver ):
   managedApiRe = "DS460-NormalDelays"


class DS460DCDriver( DS460Driver ):
   managedApiRe = "DS460DC"
   
def Plugin( ctx ):
   ctx.registerDriver( DS460ACExtraDelaysDriver )
   ctx.registerDriver( DS460ACDriver )
   ctx.registerDriver( DS460DCDriver )   
   
   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
