#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=W0232
# pylint: disable-msg=F0401
# pylint: disable-msg=E1101

import FruPlugin.PmbusPowerSupply as PmbusPowerSupply

class DS2700Driver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"

   # The READ_VOUT command is broken, these are fake values
   # to get a reasonable result so tests pass. This supply
   # will not be shipped anyway.
   directM = 5
   directB = 0
   directR = 2
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   extraDelays = False
   sendByteSupported = True
   overTempLenientDelay = 0

class DS2700ACDriver( DS2700Driver ):
   managedApiRe = "Emerson2700AC"

class DS2700DCDriver( DS2700Driver ):
   managedApiRe = "Emerson2700DC"
   negativeVinAllowed = True

def Plugin( ctx ):
   ctx.registerDriver( DS2700ACDriver )
   ctx.registerDriver( DS2700DCDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
