#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru

class CoolingDomainDirDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::CoolingDomainDir"
   provides = [ Fru.FruDriver.environmentInit ]

   def __init__( self, invCoolingDomainDir, parentMibEntity, parentDriver,
                 driverCtx ):
      super( CoolingDomainDirDriver, self ).__init__(
         invCoolingDomainDir, parentMibEntity, parentDriver, driverCtx )

      envCoolingDomainDir = driverCtx.sysdbRoot.entity[
         "environment/thermostat/coolingDomain" ]

      for coolingDomain in invCoolingDomainDir.coolingDomain.itervalues():
         envCoolingDomain = (
            envCoolingDomainDir.coolingDomain.get( coolingDomain.name ) )
         if not envCoolingDomain:
            # Only create the cooling domain if it doesn't already
            # exist. We may dynamically change minFanSpeed after
            # initialization, and after a switchover if we clobber the
            # existing cooling domain it may reset minFanSpeed to an
            # undesired value.
            envCoolingDomain = envCoolingDomainDir.newCoolingDomain(
               coolingDomain.name,
               coolingDomain.overheatThresholdRatioBase,
               coolingDomain.minFanSpeed )

         envCoolingDomain.targetToOverheatMargin = (
            coolingDomain.targetToOverheatMargin )
         envCoolingDomain.useAggressiveThresholds = (
            coolingDomain.useAggressiveThresholds )

         for ( fanKey, offset ) in coolingDomain.fanSpeedOffset.iteritems():
            slope = coolingDomain.fanSpeedSlope.get( fanKey, 1.0 )
            envCoolingDomain.fanSpeedOffset[ fanKey ] = offset
            envCoolingDomain.fanSpeedSlope[ fanKey ] = slope
            envCoolingDomain.maxFanSpeed[ fanKey ] = 100

         envCoolingDomain.baseFansDefined = coolingDomain.baseFansDefined
         for ( fanKey, priority ) in coolingDomain.baseFanKeyPriority.iteritems():
            envCoolingDomain.baseFanKeyPriority[ fanKey ] = priority
         
         envCoolingDomain.fanSlopeOffsetDefined = coolingDomain.fanSlopeOffsetDefined

      for slot, coolingDomain in invCoolingDomainDir.slotToCoolingDomain.iteritems():
         envCoolingDomainDir.slotToCoolingDomain[ slot ] = (
            envCoolingDomainDir.coolingDomain[ coolingDomain.name ] )

      if parentMibEntity.powerSupplySlot or parentMibEntity.fanTraySlot:
         # If no power supply slots or fan tray slots are defined, assume
         # we're defining PLSlots, which will be initialized in the PLSlot FruPlugin
         envCoolingDomainDir.ready = True

def Plugin( ctx ):
   ctx.registerDriver( CoolingDomainDirDriver )
   mg = ctx.entityManager.mountGroup()
   mg.mount( "environment/thermostat/coolingDomain",
             "Environment::Thermostat::CoolingDomainDir", "w" )
   mg.close( None )
