# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Fru
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.BlackBox" )
t0 = Tracing.trace0

class BlackboxDriver( Fru.FruDriver ):
   # The Blackbox driver needs to run after the Scd driver.
   requires = [ Fru.FruDriver.systemInit ]

   managedTypeName = "Inventory::Blackbox"
   managedApiRe = ".*"

   def __init__( self, invBlackbox, parentMibEnt, parentDriver, ctx ):
      Fru.FruDriver.__init__( self, invBlackbox, parentMibEnt, parentDriver, ctx )

      if invBlackbox.supported:
         t0( 'Configuring BlackBox' )
         config = ctx.sysdbRoot.entity[ Cell.path( "hardware/blackbox/config" ) ]
         config.cmdAddrSize = invBlackbox.spiCmdAddrSize 
         self.createSpiHam( invBlackbox, config )
         # The agent reacts to the supported attribute, so it should be
         # set last. Timing of plugins may allow the agent to start
         # prior to this attribute being set.
         config.supported = True

   def createSpiHam( self, invBlackbox, config ):
      if invBlackbox.accessType == 'bbTypeMemMapped':
         config.baseHam = ( 'mmapHam', 'hamTypeMemMapped', None,
                            invBlackbox.memOffset, 0, '' )
         baseHam = config.baseHam
         dep = config
      else:
         assert invBlackbox.accessType == 'bbTypeScd'
         assert invBlackbox.scd
         baseHam = invBlackbox.scd.ham
         dep = invBlackbox.scd
         assert baseHam
         assert baseHam.kind == 'hamTypePci'

      Fru.Dep( config, dep ).ham = (
         'spiHam', 'hamTypeRecursive', baseHam, invBlackbox.spiAccelOffset,
         invBlackbox.spiAccelRegStride, '' )

def Plugin( ctx ):
   ctx.registerDriver( BlackboxDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( Cell.path( "hardware/blackbox/config" ),
             "Hardware::Blackbox::Config", "wf" )
   mg.close( None )
