#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os

import ReloadConsts
import Tac
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "AcpiBert" )
t0 = Tracing.trace0
bertDataPath = "/sys/firmware/acpi/tables/data/BERT"

def Plugin( context ):
   '''
   BERT plugin that processes the ACPI BERT data.
   We propagate the reload cause info if a BERT error is detected.
   '''

   # No BERT data info available
   if not os.path.isfile( bertDataPath ):
      return

   try:
      with open( bertDataPath ) as f:
         bertData = f.read()
   except IOError as err:
      t0( "Unable to read BERT data file: %s" % err.strerror )
      return

   # Empty BERT data, this means no Boot Error Region. BERT data should be bigger
   # than 4 bytes, we need at least 4 bytes to check the Boot Error Region. If data
   # is smaller (because of some BIOS bug?) just ignore it.
   if len( bertData ) < 4:
      return

   # No error reported in the Boot Error Region (Block Status == 0)
   if all( b == '\0' for b in bertData[ 0 : 4 ] ):
      return

   ReloadCauseConstants = Tac.Type( "ReloadCause::ReloadCauseConstants" )
   RCC = ReloadCauseConstants()
   RCC.writeLocalReloadCause( ReloadConsts.cpuMachineCheckDescription, bertDataPath,
                              False )
