#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import namedtuple
from Arnet import PktParserTestLib

# Return type for getPacketInfo
PacketInfo = namedtuple( 'PacketInfo', [
      'pkt',
      'offset',
      'ethHdr',
      'ipHdr',
      'ip6Hdr',
      'mplsHdr',
      'ethDot1QHdr',
   ] )

def parseDataPacket( data, parseBeyondMpls=False ):
   info = PktParserTestLib.parsePktStr( data, parseBeyondMpls=parseBeyondMpls )
   ( pkt, headers, offset ) = info
   ethHdr = PktParserTestLib.findHeader( headers, 'EthHdr' )
   ipHdr = PktParserTestLib.findHeader( headers, "IpHdr" )
   ip6Hdr = PktParserTestLib.findHeader( headers, "Ip6Hdr" )
   mplsHdr = PktParserTestLib.findHeader( headers, "MplsHdr" )

   # We want to look for the inner-most dot1q header
   ethDot1QHdr = None
   for hdr in headers:
      # An ethernet frame begins with EthAddr, followed by EthDot1QHdrs. Any
      # subsequent headers thereafter do not start with 'Eth,' so we know we've
      # analyzed all the dot1q headers for a given ethernet frame.
      if not hdr[ 0 ].startswith( 'Eth' ):
         break
      if hdr[ 0 ] == 'EthDot1QHdr':
         ethDot1QHdr = hdr[ 1 ]

   return PacketInfo( pkt, offset, ethHdr, ipHdr, ip6Hdr, mplsHdr, ethDot1QHdr )

