#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''Contains code that are common to Flowspec CliPlugin and
CliSavePlugin'''

import Tac

ethIntfId = Tac.Type( 'Arnet::EthIntfId' )
subIntfId = Tac.Type( 'Arnet::SubIntfId' )
portChannelIntfId = Tac.Type( 'Arnet::PortChannelIntfId' )

#----------------------------------------------------------------------------
# For an interface to be capable of flow-spec, it must be an ethernet
# or port-channel interface. NOTE: sub-interfaces also evaluate
# as ethernet or port-channel.
#----------------------------------------------------------------------------
def flowspecCapable( intfName ):
   return ethIntfId.isEthIntfId( intfName ) or \
        portChannelIntfId.isPortChannelIntfId( intfName )

#----------------------------------------------------------------------------
# Helper to fetch the flow-spec command based on Flowspec::IpVersion
#----------------------------------------------------------------------------
def getFlowspecCmdFrom( ipVersion ):
   if not ipVersion.ipv4 and not ipVersion.ipv6:
      return "no flow-spec ipv4 ipv6"
   elif ipVersion.ipv4 and not ipVersion.ipv6:
      return "flow-spec ipv4"
   elif not ipVersion.ipv4 and ipVersion.ipv6:
      return "flow-spec ipv6"
   else:  # ipVersion.ipv4 and ipVersion.ipv6
      return "flow-spec ipv4 ipv6"
