# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

sampleRate = Tac.Type( "FlowTracking::SampleRate" )
activeInterval = Tac.Type( "FlowTracking::ActiveInterval" )
inactiveTimeout = Tac.Type( "FlowTracking::InactiveTimeout" )
ipfixVersion = Tac.Type( "FlowTracking::IpfixVersion" )
ipfixMtu = Tac.Type( "FlowTracking::IpfixMtu" )
ipfixPort = Tac.Type( "FlowTracking::L4Port" )
templateInterval = Tac.Type( "FlowTracking::TemplateInterval" )
constants = Tac.newInstance( "FlowTracking::Constants" )
ftId = Tac.Type( "FlowTracking::FtId" )
accessListDefault = Tac.Value( "FlowTracking::AccessList" )
mirrorConfigDefault = Tac.Value( "FlowTracking::MirrorConfig" )
initialCopy = Tac.Type("FlowTracking::InitialCopy" )
mirrorIntervalFixed = Tac.Type("FlowTracking::MirrorIntervalFixed" )
mirrorIntervalRandom = Tac.Type("FlowTracking::MirrorIntervalRandom" )
mirrorSelectorAlgo = Tac.Type("FlowTracking::MirrorSelectorAlgo")
reservedGroupNames = Tac.newInstance( "FlowTracking::ReservedGroupNames" )

spaceConst = '   '

# Printing helper method for outputing "(Default)" next
# to a value that matches the default value
def valueWithDefaultInd( value, default ):
   if value == default:
      return "%s (default)" % value
   else:
      return "%s" % value
