# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, print_function, division
import Tac

# Get adjType enum values from TAC model instead of hardcoding them
adjTypeV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibV4Adj' )
adjTypeV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibV6Adj' )
adjTypeResilientEcmp = Tac.enumValue( 'Smash::Fib::AdjType', 'resilientEcmpAdj' )
adjTypeNextHopGroup = Tac.enumValue( 'Smash::Fib::AdjType', 'nextHopGroupAdj' )
adjTypeAttached = Tac.enumValue( 'Smash::Fib::AdjType', 'attachedAdj' )
adjTypeNextHop = Tac.enumValue( 'Smash::Fib::AdjType', 'nexthopAdj' )
adjTypeMplsTunnel = Tac.enumValue( 'Smash::Fib::AdjType', 'tunnelFibAdj' )
adjTypeEvpnV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'evpnV4Adj' )
adjTypeEvpnV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'evpnV6Adj' )
adjTypeMplsV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'mplsV4Adj' )
adjTypeMplsV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'mplsV6Adj' )
adjTypeFloodSet = Tac.enumValue( 'Smash::Fib::AdjType', 'floodSetAdj' )
adjTypePwLocal = Tac.enumValue( 'Smash::Fib::AdjType', 'pwLocalAdj' )
adjTypePwDecap = Tac.enumValue( 'Smash::Fib::AdjType', 'pwDecapAdj' )
adjTypeSrTePolicyFec = Tac.enumValue( 'Smash::Fib::AdjType', 'srTePolicyAdj' )
adjTypeUsedByTunnelV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'usedByTunnelV4Adj' )
adjTypeUsedByTunnelV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'usedByTunnelV6Adj' )
adjTypeL2NexthopGroup = Tac.enumValue( 'Smash::Fib::AdjType', 'l2NexthopGroupAdj' )
adjTypeNexthopV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'nexthopV4Adj' )
adjTypeNexthopV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'nexthopV6Adj' )
adjTypeMax = Tac.enumValue( 'Smash::Fib::AdjType', 'adjTypeMax' )

# Get adjType bit fields from TAC model instead of hardcoding them
tacFecIfAdjConstType = Tac.Type( 'Smash::Fib::FecIdAdjConstants' )
adjTypePos = tacFecIfAdjConstType.typePos
adjIndexMask = tacFecIfAdjConstType.indexMask
adjTypeMask = tacFecIfAdjConstType.typeMask

# Get fec Id enum values from TAC model instead of hardcoding them
fecIdInvalid = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'invalidFecId' )
fecIdIpv4Drop = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'ipv4DropFecId' )
fecIdIpv6Drop = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'ipv6DropFecId' )
fecIdConstantMax = fecIdIpv6Drop

# These constants are not synced to any TAC models
fecIdToIntfIdIndexMask = 0x000000FFFFFFFFFF
fecIdToIntfIdIndexPos = 40
