# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, FdlInventoryInitializer

class XcvrInventoryDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::Xcvr::SlotDir"
   def initInventoryEntry( self, **kwargs ):
      slotType = kwargs[ 'slotType' ]
      slotId = kwargs[ 'slotId' ]
      txTraceIds = kwargs.get( 'txTraceIds', None )
      rxTraceIds = kwargs.get( 'rxTraceIds', None )

      cfp2Supported = False
      cfpxSupported = False
      cfp2DcoSupported = False 
      hitfullOnSpeedChange = False
      agilePort = False
      maxBlockReadSize = 0
      maxPowerSupported = kwargs.get( 'maxPowerSupported', 0.0 )

      if slotType == 'cfp2':
         cfp2Supported = kwargs[ 'cfp2Supported' ]
         cfpxSupported = kwargs[ 'cfpxSupported' ]
         cfp2DcoSupported = kwargs.get( 'cfp2DcoSupported', False )
      elif slotType in ( 'qsfp', 'qsfpDd', 'osfp', 'qsfpCmis' ):
         hitfullOnSpeedChange = kwargs[ 'hitfullOnSpeedChange' ]
      elif slotType == 'sfp':
         agilePort = kwargs.get( 'agilePort', False )
         maxBlockReadSize = kwargs.get( 'maxBlockReadSize', 0 )
      else:
         assert 0, "Unhandled slotType"

      xcvrSlot = self.invEntity_.newXcvrSlot( slotId, slotType )
      capabilities = Tac.Value( "Inventory::Xcvr::XcvrSlotCapabilities" )
      capabilities.cfp2Supported = cfp2Supported
      capabilities.cfpxSupported = cfpxSupported
      capabilities.cfp2DcoSupported = cfp2DcoSupported
      capabilities.hitfullOnSpeedChange = hitfullOnSpeedChange
      capabilities.agilePort = agilePort 
      capabilities.maxPowerSupported = maxPowerSupported
      capabilities.maxBlockReadSize = maxBlockReadSize
      xcvrSlot.xcvrSlotCapabilities = capabilities

      if txTraceIds and rxTraceIds:
         if slotType == 'sfp':
            numLanes = 1
         elif slotType in ( 'qsfp', 'qsfpCmis' ):
            numLanes = 4
         elif slotType in ( 'qsfpDd', 'osfp' ):
            numLanes = 8
         else:
            assert 0, "Unsupported SlotType for TraceIds"

         for i in range( numLanes ):
            xcvrSlot.txTraceId[ i ] = txTraceIds[ i ]
            xcvrSlot.rxTraceId[ i ] = rxTraceIds[ i ]

      return xcvrSlot

def Plugin( context ):
   context.registerInitializer( XcvrInventoryDirInitializer )
