#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, FdlInventoryInitializer

class SflowAccelFpgaDirInitializer( FdlInventoryInitializer.DirInitializer ):

   managedTypeName = "Inventory::SflowAccelFpga::SflowAccelFpgaDir"

   def initInventoryEntry( self, **kwargs ):
      sflowAccelFpgaId = kwargs[ 'sflowAccelFpgaId' ]

      if sflowAccelFpgaId not in self.invTableInfo_:
         return None

      sflowAccelFpgaInfo = self.invTableInfo_[ sflowAccelFpgaId ]
      ( sliceId, sflowAccelFpga, parentPciBridge,
        sflowAccelFpgaCount, sflowAccelFpgaType ) = sflowAccelFpgaInfo[ :5 ]

      args = sflowAccelFpgaInfo[ 5: ]

      assert( sflowAccelFpgaCount > 0 )

      AccelId = Tac.Type( "Hardware::SflowAccel::AccelId" )
      accelId = AccelId( AccelId.makeAccelId(
         AccelId.nullSlice if sliceId is None else sliceId, sflowAccelFpgaId ) )
      name = accelId.accelName()

      invSflowAccelFpga = self.invEntity_.newSflowAccelFpga( name, accelId )
      invSflowAccelFpga.sflowAccelFpgaType = sflowAccelFpgaType
      invSflowAccelFpga.pciId = Tac.Value( "Inventory::PciId",
                                           vendor=0x3475, device=0x0004 )
      invSflowAccelFpga.address = Tac.Value( "Inventory::PciAddress",
                                             domain=0, bus=256, slot=0,
                                             function=0 )

      if args:
         assert len( args ) == 1
         invSflowAccelFpga.resetDevice = args[ 0 ]

      if sflowAccelFpga:
         invSflowAccelFpga.sflowAccelFpga = sflowAccelFpga
      else:
         assert parentPciBridge
         # Create the Fpga Pcie connection to the parent pci bridge.
         cr = parentPciBridge.bus.newConnection( 0 )
         invSflowAccelFpga.connection = ( 0, )
         invSflowAccelFpga.connection.associatedEntity = invSflowAccelFpga
         invSflowAccelFpga.connection.otherEndpoint = cr
         cr.associatedEntity = parentPciBridge
         cr.otherEndpoint = invSflowAccelFpga.connection

      return invSflowAccelFpga

   def addFpgaProgramer( self, fpgaId, scd, fpgaName, scdFpgaProgrammingBlockAddr,
                         fpgaImage, fpgaResetBlockName, fpgaResetBit ):
      assert scd
      fpgaProgrammingBlock = scd.invScd.newFpgaProgrammingBlock(
         fpgaName + "Programming", scdFpgaProgrammingBlockAddr )
      fpgaSel = 1 << fpgaId
      fpgaProgrammer = fpgaProgrammingBlock.newFpgaToBeProgrammed(
         fpgaName, fpgaImage, fpgaSel )
      fpgaProgrammer.firstReset = ( 'firstReset', 0.001, )
      fpgaProgrammer.secondReset = ( 'secondReset', 0.0, )
      fpgaProgrammer.fpgaBitFlipByteSwap = True
      gpoBlock = scd.invScd.setClearGpoBlock[ fpgaResetBlockName ]
      fpgaResetPin = gpoBlock.newBit( fpgaResetBit )
      fpgaProgrammer.firstReset.resetPins[ fpgaId ] = fpgaResetPin
      fpgaProgrammer.secondReset.resetPins[ fpgaId ] = fpgaResetPin

def Plugin( context ):
   context.registerInitializer( SflowAccelFpgaDirInitializer )

