# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import FdlInventoryInitializer

class PtpTimeSyncSlaveDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::PtpTimeSync::SlaveDir"
   def initInventoryEntry( self, **kwargs ):
      ptpTimeSyncSlave = self.invEntity_.newSlave( kwargs['name'] )
      ptpTimeSyncSlave.topology = kwargs['topology']
      ptpTimeSyncSlave.timeSyncDelay = kwargs['timeSyncDelay']
      ptpTimeSyncSlave.inputFreqMultiplier = kwargs['inputFreqMultiplier']
      ptpTimeSyncSlave.pllIsStandalone = \
            kwargs.get( 'pllIsStandalone', False )
      ptpTimeSyncSlave.invertFpgaSupeSel = kwargs.get( 'invertFpgaSupeSel', False )
      ptpTimeSyncSlave.internalSyncMode = kwargs.get( 'internalSyncMode',
                                                      'broadsync' )
      ptpTimeSyncSlave.reqsAlwaysOnTimeSync = \
            kwargs.get( 'reqsAlwaysOnTimeSync', False )
      ptpTimeSyncSlave.sourceClockTimestamp = kwargs.get( 'sourceClockTimestamp',
                                                          'external' )
      ptpTimeSyncSlave.supeSelectOffset = kwargs.get( 'supeSelectOffset', 0x0 )
      return ptpTimeSyncSlave


class PtpTimeSyncMasterInitializer( FdlInventoryInitializer.Initializer ):
   managedTypeName = "Inventory::PtpTimeSync::Master"
   def initInventory( self, **kwargs ):
      self.invEntity_.block = kwargs['block']
      self.invEntity_.timeSyncVersion = kwargs['timeSyncVersion']
      self.invEntity_.delayOffset = kwargs['delayOffset']
      self.invEntity_.outputFrequency = kwargs[ 'outputFrequency' ]
      self.invEntity_.alwaysOnClock = kwargs[ 'alwaysOnClock' ]
      self.invEntity_.requiresInternalPllReset = kwargs.get(
         'requiresInternalPllReset',
         False )
      self.invEntity_.internalSyncMode = kwargs.get(
         'internalSyncMode',
         'broadsync' )
      self.invEntity_.pidControllerSupported = kwargs.get(
         'pidControllerSupported',
         True )
      self.invEntity_.hasStableClockInternalPll = kwargs.get(
         'hasStableClockInternalPll',
         False )
      self.invEntity_.stableClockOffset = kwargs.get(
         'stableClockOffset',
         0x0 )
      return self.invEntity_

def Plugin( context ):
   context.registerInitializer( PtpTimeSyncSlaveDirInitializer )
   context.registerInitializer( PtpTimeSyncMasterInitializer )
