#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import FdlInventoryInitializer

class DefaultPlutoLibInitializer( FdlInventoryInitializer.Initializer ):
   managedTypeName = "Inventory::PlutoLibrary"
   def initInventoryEntry( self, **kwargs ):
      libPath = kwargs[ 'libPath' ]
      self.invEntity_.libPath = libPath

class PLSlotInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::PLSlotDir"
   def initInventoryEntry( self, **kwargs ):
      fanTraySlotIds = kwargs[ 'fanTraySlotIds' ]
      for fanTraySlotId in fanTraySlotIds:
         fanTraySlot = self.invEntity_.newSlot( "FanTray%d" % fanTraySlotId )
         fanTraySlot.slotType = "FanTray"
         fanTraySlot.slotId = fanTraySlotId
         fanTraySlot.coolingDomain = "FixedSystem"

      psuSlotIds = kwargs[ 'psuSlotIds' ]
      for psuSlotId in psuSlotIds:
         psuSlot = self.invEntity_.newSlot( "PowerSupply%d" % psuSlotId )
         psuSlot.slotType = "PowerSupply"
         psuSlot.slotId = psuSlotId
         psuSlot.coolingDomain = "FixedSystem"

class PLDeviceDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::PLDeviceDir"
   def initInventoryEntry( self, **kwargs ):
      group = kwargs[ 'group' ]
      device = self.invEntity_.newDevice( group )
      device.group = group
      return device

class PLDeviceInitializer( FdlInventoryInitializer.Initializer ):
   managedTypeName = "Inventory::PLDevice"
   def initInventoryEntry( self, **kwargs ):
      assert 0, "Not supported; use initTempSensor instead"

   def initTempSensor( self, **kwargs ):
      name = kwargs[ 'name' ]
      ts = self.invEntity_.newTempSensor( name )
      ts.sensorId = kwargs[ 'sensorId' ]
      ts.description = kwargs[ 'description' ]
      ts.position = kwargs[ 'position' ]
      ts.overheatThreshold = kwargs[ 'overheatThreshold' ]
      ts.criticalThreshold = kwargs[ 'criticalThreshold' ]

   def initFanTrayLed( self, **kwargs ):
      name = 'FanTray%d' % kwargs[ 'fanTraySlotId' ]
      self.initLed( name, kwargs.get( 'libPath' ) )

   def initLed( self, name, libPath ):
      led = self.invEntity_.newLed( name )
      if libPath:
         led.libPath = libPath

def Plugin( context ):
   context.registerInitializer( PLSlotInitializer )
   context.registerInitializer( DefaultPlutoLibInitializer )
   context.registerInitializer( PLDeviceInitializer )
   context.registerInitializer( PLDeviceDirInitializer )
