#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, FdlInventoryInitializer

class IpsecInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::Ipsec::IpsecDir"

   def initInventoryEntry( self, **kwargs ):
      chipId = kwargs.get( 'chipId', 0 )
      ipsec = self.invEntity_.newIpsec( "Ipsec", chipId )
      return ipsec

def Plugin( context ):
   context.registerInitializer( IpsecInitializer )

