# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import FdlInventoryInitializer

class Ac400InventoryDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = 'Inventory::Denali::Ac400Dir'
   def initInventoryEntry( self, **kwargs ):
      slotId = kwargs[ 'slotId' ]
      chipId = kwargs[ 'chipId' ]
      resetBlocks = kwargs[ 'resetBlocks' ]
      cfpDspCtlBlock = kwargs[ 'cfpDspCtlBlock' ]
      interruptBlocks = kwargs[ 'interruptBlocks' ]
      mdioBuses = kwargs[ 'mdioBuses' ]
      ethPortDir = kwargs[ 'ethPortDir' ] # dict indexed by name
      xcvrSlotDir = kwargs[ 'xcvrSlotDir' ] # dict indexed by name
      sensorId = kwargs[ 'sensorId' ]
      chipName = 'Ac400-%d/%d' % ( slotId, chipId )

      if chipId not in self.invTableInfo_:
         return None

      ( mdioAccelId, mdioBusId, mdioAddr, resetGpoNum, resetBit,
        modLoPwrBlock, modLoPwrBit, gblAlarmBlock, gblAlrmBit,
        prgAlarmBlock, prgAlrm1Bit,
        _, _, _, _, serdesSetting,
        #lineTxPolaritySwap, lineTxPolaritySwap,
        #systemTxPolaritySwap, systemRxPolaritySwap,
        ethPortIds, xcvrSlotData ) = self.invTableInfo_[ chipId ]

      ac400 = self.invEntity_.newPhy( chipName, mdioAddr )
      for i in range( Tac.Type( "DenaliTypes::HostClientIntfId" ).max ):
         ac400.newHostLane( i )

      ac400.modelName = 'Ac400'
      ac400.vendorType = 'Acacia'
      ac400.hardwareRev = '1.0'
      ac400.api = '1.0'
      ac400.description = 'Acacia Ac400 DSP %d/%d' % ( slotId, chipId )
      for xcvrSlotId, networkLane, txHvSwap, txHiqSwap, txViqSwap, txHiqSkew, \
          txViqSkew, in xcvrSlotData:
         networkLane = ac400.newNetworkLane( networkLane )
         networkLane.txHvSwap = txHvSwap
         networkLane.txHiqSwap = txHiqSwap
         networkLane.txViqSwap = txViqSwap
         networkLane.txHiqSkew = txHiqSkew
         networkLane.txViqSkew = txViqSkew
         networkLane.xcvrSlot = xcvrSlotDir.xcvrSlot[ xcvrSlotId ]
      for idx, ethPortId in enumerate( ethPortIds ):
         ac400.port.addMember( ethPortDir.port[ ethPortId ] )
         # add new serdes setting
         ac400.hostLane[ idx ].hostRxTap0Gain = serdesSetting[ idx ][ 0 ]
         ac400.hostLane[ idx ].hostRxTap0Delay = serdesSetting[ idx ][ 1 ]
         ac400.hostLane[ idx ].hostRxTap1Gain = serdesSetting[ idx ][ 2 ]
         ac400.hostLane[ idx ].hostRxTap2Gain = serdesSetting[ idx ][ 3 ]
         ac400.hostLane[ idx ].hostRxTap2Delay = serdesSetting[ idx ][ 4 ]

      resetBlockName = "resetGpo%d" % resetGpoNum
      ac400.reset = resetBlocks[ resetBlockName ].newBit( resetBit )
      modLoPwrBlockName = "cfpDspCtlGpo%d" % modLoPwrBlock
      ac400.modLoPwr = cfpDspCtlBlock[ modLoPwrBlockName ].newBit( modLoPwrBit )
      gblAlarmBlockName = "interruptBlock%d" % gblAlarmBlock
      ac400.interruptController = interruptBlocks[ gblAlarmBlockName ].newBit( 
                                                              gblAlrmBit )
      prgAlarmBlockName = "interruptBlock%d" % prgAlarmBlock
      ac400.prgAlrm1 = interruptBlocks[ prgAlarmBlockName ].newBit( prgAlrm1Bit )

      # In the Scd simulation (breadth tests), the ScdTestLib sets this up for us
      mdioBus = mdioBuses[ "mdioBus%d:%d" % ( mdioAccelId, mdioBusId ) ]
      ac400.upstreamBus = mdioBus
      mdioBus.device.addMember( ac400 )

      # Create the tempSensor inventory object
      ac400.tempSensor = ( sensorId, )
      ac400.tempSensor.description = chipName
      ac400.tempSensor.groupName = "Ac400Dsp"
      ac400.tempSensor.overheatThreshold = 85
      ac400.tempSensor.criticalThreshold = 95
      ac400.tempSensor.targetTemperature = 110
      ac400.tempSensor.ultimateGainFrontToBack = 0.4
      ac400.tempSensor.ultimatePeriodFrontToBack = 800
      ac400.tempSensor.position = 'other'
      ac400.tempSensor.offset = 0
      ac400.tempSensor.ignoreForBoardInitialization = True

      return ac400

def Plugin( context ):
   context.registerInitializer( Ac400InventoryDirInitializer )
