# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
This module defines useful python bindings and enum aliases for the FabricIntf
package.

It should be used by tests, FRU plugins, etc... Instead of manually
declaring the TAC types/ using strings.
'''

from __future__ import absolute_import, division, print_function

import Tac
from HwL1TopologyComponentLib.Serdes import (
   FEC_NOFEC,
   FEC_RS528,
   LANE_COUNT_1,
   LANE_COUNT_2,
   LANE_COUNT_4,
   SPEED_GBPS_10,
   SPEED_GBPS_25,
   SPEED_GBPS_40,
   SPEED_GBPS_50,
   SPEED_GBPS_100,
)

ResourceConstraintStatusAggregator = Tac.Type(
   'Fabric::ResourceConstraintStatusAggregator' )

FabricIntfStatusDirGenerationFilter = Tac.Type(
   'Fabric::FabricIntfStatusDirGenerationFilter' )

FabricIntfStatusPtrConstDir = Tac.Type( 'Interface::FabricIntfStatusPtrConstDir' )

FabricResourceConstraintStatus = Tac.Type(
   'Interface::FabricResourceConstraintStatus' )
FabricResourceConstraintIntfStatus = Tac.Type(
   'Interface::FabricResourceConstraintIntfStatus' )

FabricIntfStatus = Tac.Type( 'Interface::FabricIntfStatus' )
FabricIntfStatusDir = Tac.Type( 'Interface::FabricIntfStatusDir' )
FabricPeerIntfInfo = Tac.Type( 'Interface::FabricPeerIntfInfo' )

FabricConfig = Tac.Type( 'Fabric::Config' )

FabricEncap = Tac.Type( 'Interface::FabricEncap::FabricEncap' )
ENCAP_BCM_UNKNOWN = FabricEncap.unknown
ENCAP_BCM_IEEE = FabricEncap.bcmIeee
ENCAP_BCM_HIGIG = FabricEncap.bcmHigig
ENCAP_BCM_CES = FabricEncap.bcmCes

FabricIntfState = Tac.Type( 'Interface::FabricIntfState' )
def fabricIntfStateFactory( intfId, hwState ):
   fabricIntfState = FabricIntfState( intfId )
   fabricIntfState.state = hwState
   return fabricIntfState

# TODO BUG464617 Remove this and consolidate types once IntfHwState merges into
# eos-trunk.
FabricIntfHwState = Tac.Type( 'Interface::FabricIntfHwState::FabricIntfHwState' )
INTERFACE_STATE_ACTIVE = FabricIntfHwState.active
INTERFACE_STATE_INACTIVE = FabricIntfHwState.inactive

# TODO BUG464314 Add the ability to specify duplex
FabricIntfMode = Tac.Type( 'Interface::FabricIntfMode' )
def fabricIntfModeFactory( intfId, speed, lanes, fec, encap ):
   fabricIntfMode = FabricIntfMode( intfId )
   fabricIntfMode.speed = speed
   fabricIntfMode.laneCount = lanes
   fabricIntfMode.fec = fec
   fabricIntfMode.encap = encap

   return fabricIntfMode

G100_4_NOFEC_HIGIG = fabricIntfModeFactory( "", SPEED_GBPS_100, LANE_COUNT_4,
                                            FEC_NOFEC, ENCAP_BCM_HIGIG )
G100_4_NOFEC_CES = fabricIntfModeFactory( "", SPEED_GBPS_100, LANE_COUNT_4,
                                          FEC_NOFEC, ENCAP_BCM_CES )
G100_4_RS528_IEEE = fabricIntfModeFactory( "", SPEED_GBPS_100, LANE_COUNT_4,
                                           FEC_RS528, ENCAP_BCM_IEEE )
G50_2_NOFEC_HIGIG = fabricIntfModeFactory( "", SPEED_GBPS_50, LANE_COUNT_2,
                                           FEC_NOFEC, ENCAP_BCM_HIGIG )
G50_2_NOFEC_CES = fabricIntfModeFactory( "", SPEED_GBPS_50, LANE_COUNT_2,
                                         FEC_NOFEC, ENCAP_BCM_CES )
G50_2_RS528_IEEE = fabricIntfModeFactory( "", SPEED_GBPS_50, LANE_COUNT_2,
                                          FEC_RS528, ENCAP_BCM_IEEE )
G40_4_NOFEC_HIGI = fabricIntfModeFactory( "", SPEED_GBPS_40, LANE_COUNT_4,
                                          FEC_NOFEC, ENCAP_BCM_HIGIG )
G25_1_NOFEC_HIGIG = fabricIntfModeFactory( "", SPEED_GBPS_25, LANE_COUNT_1,
                                          FEC_NOFEC, ENCAP_BCM_HIGIG )
G25_1_NOFEC_CES = fabricIntfModeFactory( "", SPEED_GBPS_25, LANE_COUNT_1,
                                         FEC_NOFEC, ENCAP_BCM_CES )
G25_1_RS528_IEEE = fabricIntfModeFactory( "", SPEED_GBPS_25, LANE_COUNT_1,
                                          FEC_RS528, ENCAP_BCM_IEEE )
G10_1_NOFEC_HIGIG = fabricIntfModeFactory( "", SPEED_GBPS_10, LANE_COUNT_1,
                                           FEC_NOFEC, ENCAP_BCM_HIGIG )
G10_1_NOFEC_CES = fabricIntfModeFactory( "", SPEED_GBPS_10, LANE_COUNT_1,
                                         FEC_NOFEC, ENCAP_BCM_CES )
G10_1_RS528_IEEE = fabricIntfModeFactory( "", SPEED_GBPS_10, LANE_COUNT_1,
                                          FEC_RS528, ENCAP_BCM_IEEE )

InterfaceModeConfigPolicy = Tac.Type(
   'Fabric::InterfaceModeConfigPolicy::InterfaceModeConfigPolicy')
INTERFACE_MODE_CONFIG_POLICY_FIXED = InterfaceModeConfigPolicy.fixed
INTERFACE_MODE_CONFIG_POLICY_FP_MATCH = InterfaceModeConfigPolicy.frontPanelMatching
INTERFACE_MODE_CONFIG_POLICY_FABRIC_MATCH = InterfaceModeConfigPolicy.fabricMatching
