#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing


__defaultTraceHandle__ = Tracing.Handle( 'ExtensionMgrPyPi' )
t3 = Tracing.trace2

# This module provides the package manager interface interface for PyPi
# repositories/packages.


def updateRepository( repo, timeout=60 ):
   #BUG94891
   t3( 'update repo', repo.name )


def deleteRepository( repo ):
   #BUG94891
   t3( 'delete repo', repo.name )


def packageDownload( name, repo ):
   #BUG94891
   t3( 'package download', name, 'from', repo.url )
   """
   # Delay the imports due to the module importing memory hogs.
   import pip
   import pip.locations
   import pip.req

   # XXX use a tmpdir so that we don't blow away existing files
   # until we're ready to
   dst = '/mnt/flash/.extensions'
   reqs = pip.req.RequirementSet(
      pip.locations.build_prefix, pip.locations.src_prefix, dst )
   finder = pip.index.PackageFinder( [], index_urls=[ repo.url ] )
   reqs.add_requirement( pip.req.InstallRequirement.from_line( name, None ) )

   # Cleanup the temporary directory then trigger package downloads
   reqs.cleanup_files()
   reqs.prepare_files( finder )
   reqs.cleanup_files()

   # XXX how to get the downloaded filenames for each package? The local
   # filename is elusively not in the packages in the reqs.successfully_downloaded
   # list. Will have to scan the dst directory for files starting with this name.
   # Get information about the packages downloaded from the requirements set
   key = Tac.Value( 'Extension::InfoKey', name, repo.format, 0 )
   v = Tac.newInstance( 'Extension::Info', key )

   for package in reqs.successfully_downloaded:
      pkg = v.package.newMember( name )
      pkg.packageName = package.name
      pinfo = None
      try:
         pinfo = package.pkg_info()
      except EnvironmentError:
         # a bogus PKG-INFO setup, we can't get more info on these for now.
         continue
      else:
         if 'Version' in pinfo:
            pkg.version = pinfo[ 'Version' ]
         if 'Summary' in pinfo:
            pkg.summary = pinfo[ 'Version' ]
         if 'Home-page' in pinfo:
            pkg.url = pinfo[ 'Home-page' ]
         # XXX afort - get License info from multi-valued value Classifier
      # dir(package) == ['__class__', '__delattr__', '__dict__',
      # '__doc__', '__format__', '__getattribute__', '__hash__',
      # '__init__', '__module__', '__new__', '__reduce__',
      # '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__',
      # '__str__', '__subclasshook__', '__weakref__',
      # '_clean_zip_name', '_egg_info_path', '_filter_install',
      # '_is_bundle', '_requirements_section_re', '_run_setup_py',
      # '_temp_build_dir', 'absolute_versions', 'archive', 'as_egg',
      # 'assert_source_matches_version', 'build_location',
      # 'bundle_requirements', 'check_if_exists', 'comes_from',
      # 'commit_uninstall', 'conflicts_with',
      # 'correct_build_location', 'delete_marker_filename',
      # 'dependency_links', 'editable', 'egg_info_data',
      # 'egg_info_lines', 'egg_info_path', 'extras', 'from_editable',
      # 'from_line', 'from_path', 'install', 'install_editable',
      # 'install_succeeded', 'installed_version', 'is_bundle',
      # 'move_bundle_files', 'name', 'pkg_info',
      # 'remove_temporary_source', 'req', 'requirements',
      # 'rollback_uninstall', 'run_egg_info', 'satisfied_by',
      # 'setup_py', 'source_dir', 'uninstall', 'uninstalled',
      # 'update', 'update_editable', 'url', 'url_name',
      # 'use_user_site']
   return v
   """


def packageSearch( query, repo ):
   #BUG94891
   #t3( 'package search', query, 'in', repo )
   # Delayed import
   #import pip
   #args = [ 'search', '--index-url', repo.url, query ]
   #pip.main( initial_args=args )
   return

def getInstalledVersion( name ):
   t3( 'get installed version ', name )
