#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

# Pre declare variables inserted into this scope by Logging.logD
EXTENSION_INSTALLING = None
Logging.logD( id="EXTENSION_INSTALLING",
   severity=Logging.logInfo,
   format="Installing extension %s, version %s, SHA-1 %s",
   explanation="EOS has started to install the extension.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_INSTALLED = None
Logging.logD( id="EXTENSION_INSTALLED",
   severity=Logging.logInfo,
   format="Extension %s has been installed.",
   explanation="The extension has been installed.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_INSTALL_ERROR = None
Logging.logD( id="EXTENSION_INSTALL_ERROR",
   severity=Logging.logError,
   format="Extension %s failed to install: %s",
   explanation="The extension failed to install.  The log message may contain "
               "a reason why installation failed, such as a missing "
               "dependency.",
   recommendedAction="Determine why the extension failed to install.  If a "
                     "dependency is missing, install it.  If you are unsure "
                     "how to proceed, contact the developer of the extension "
                     "or your support representative." )

EXTENSION_SIGNATURE_VALID = None
Logging.logD( id="EXTENSION_SIGNATURE_VALID",
      severity=Logging.logInfo,
      format="Extension %s has a valid signature.",
      explanation="The extension has a valid digital signature.",
      recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_SIGNATURE_INVALID = None
Logging.logD( id="EXTENSION_SIGNATURE_INVALID",
      severity=Logging.logWarning,
      format="Extension %s has an invalid signature: %s",
      explanation="The extension has an invalid signature, or the signature"
                  " could not be determined. The log message may"
                  " contain a reason for the error.",
      recommendedAction="Examine the extension and determine if the contents"
                        " are correct. If the contents are not as expected,"
                        " uninstall the extension immediately. If you are unsure"
                        " how to proceed, contact the developer of the extension"
                        " or your support representative." )

EXTENSION_RESTARTING_AGENTS = None
Logging.logD( id="EXTENSION_RESTARTING_AGENTS",
      severity=Logging.logInfo,
      format="Extension installation finalization: restarting agents: %s",
      explanation="Agents are being restarted by operator request, in order to"
                  " cause a software upgrade/patch to become effective.",
      recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALLING = None
Logging.logD( id="EXTENSION_UNINSTALLING",
   severity=Logging.logInfo,
   format="Uninstalling extension %s",
   explanation="EOS has started to uninstall the extension.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALLED = None
Logging.logD( id="EXTENSION_UNINSTALLED",
   severity=Logging.logInfo,
   format="Extension %s has been uninstalled.",
   explanation="The extension has been uninstalled.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALL_ERROR = None
Logging.logD( id="EXTENSION_UNINSTALL_ERROR",
   severity=Logging.logError,
   format="Extension %s failed to uninstall: %s",
   explanation="The extension failed to uninstall.  The message may contain "
               "a reason why uninstallation failed, such as a dependency from "
               "another installed extension.",
   recommendedAction="Determine why the extension failed to uninstall.  Some "
                     "extensions may not support uninstall, requiring a reboot "
                     "of the switch to remove the extension.  If you are unsure "
                     "how to proceed, contact the developer of the extension or "
                     "your support representative." )

EXTENSION_STATUS_SAVE_ERROR = None
Logging.logD( id="EXTENSION_STATUS_SAVE_ERROR",
   severity=Logging.logError,
   format="Failed to write extension status to %s: %s",
   explanation="Cannot write extension status to the filesystem. Extension status "
              "may not be restored if Sysdb restarts.",
   recommendedAction="Check if the filesystem is full." )

PACKAGE_REPO_CREATED = None
Logging.logD( id="PACKAGE_REPO_CREATED",
   severity=Logging.logInfo,
   format="Package repository %s has been created.",
   explanation="The package repository has been created.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

PACKAGE_REPO_DELETED = None
Logging.logD( id="PACKAGE_REPO_DELETED",
   severity=Logging.logInfo,
   format="Package repository %s has been deleted.",
   explanation="The package repository has been deleted.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )
