#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Exception/error classes for the extension manager

class Error( Exception ):
   """ExtensionMgr's base error class."""


class UninstallError( Error ):
   """An error occurred during uninstallation."""


class InstallError( Error ):
   """An error occurred during installation."""


class RpmInstallError( Error ):
   def __init__( self, message, problems=None ):
      """Takes a text message and the output of rpm.ts.check as arguments."""
      Error.__init__( self, message )
      self.problems = problems


class ExtensionReadError( Error ):
   """An error occurred while reading an extension"""


class RpmReadError( ExtensionReadError ):
   """A read error occurred while processing an RPM."""


class SwixReadError( ExtensionReadError ):
   """An error occurred while reading a SWIX."""


class RpmUninstallError( Error ):
   def __init__( self, message, problems=None ):
      """Takes a text message and the output of rpm.ts.check or rpm.ts.run as
      arguments."""
      Error.__init__( self, message )
      self.problems = problems


class PackageNotAvailableError( InstallError ):
   """The package was not available from remote repositories."""


class NoRepoError( Error ):
   """There were no package repositories configured for search or download."""

class PackageNameDownloadMismatchError( InstallError ):
   """The package was downloaded, but could not be found for installation."""

class InstallInfoError( InstallError ):
   """Required blessed status in install.yaml file doesn't match current blessed
   status, or required version pattern doesn't match current version"""

class SignatureVerificationError( Error ):
   """ An unexpected error occurred during signature verification.
   Ex SSL profile config for specifying root certs does not exist. """
