#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing, Tac

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "EventMon" )

class MrouteEventMonTable( object ):
   @staticmethod
   def name():
      return "mroute"

   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "vrf", "text", True ),
         ( "sourceIp", "text", True ),
         ( "groupIp", "text", True ),
         ( "intf", "text", True ),
         ( "intfType", "text", False ),
         ( "delta", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         )

def Plugin( ctx ):
   ctx.registerDb( MrouteEventMonTable() )
