#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing, Tac

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "EventMon" )

class MacEventMonTable( object ):
   @staticmethod
   def name():
      return "mac"

   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "fid", "integer", False ),
         ( "ethAddr", "text", True ),
         ( "intf", "text", True ),
         ( "type", "text", False ),
         ( "delta", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         )

def Plugin( ctx ):
   ctx.registerDb( MacEventMonTable() )
