#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class LacpEventMonTable( object ):
   @staticmethod
   def name():
      return "lacp"

   @staticmethod
   def schema():
      return ( 
         ( "time", "text", False ),
         ( "intf", "text", True ),
         ( "portchannel", "text", True ),
         ( "statemachine", "text", True ),
         ( "state", "text", False ),
         ( "reason", "int16", False ),
         ( "portenabled", "int16", False ),
         ( "lacpenabled", "int16", False ),
         ( "currentwhiletimerexpired", "int16", False ),
         ( "lacpdurx", "int16", False ),
         ( "portmoved", "int16", False ),
         ( "selected", "text", False ),
         ( "partnersync", "int16", False ),
         ( "counter", "integer UNIQUE", False ),
         )
  
def Plugin( ctx ):
   ctx.registerDb( LacpEventMonTable() )
