#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os, sys, subprocess, Tracing

traceHandle = Tracing.defaultTraceHandle()
t0 = traceHandle.trace0

import Atcollector
collectorsPath = Atcollector.__path__[0] + '/collectors/0/'

sources = {}

def parseLine( line ):
   counter = line.split( ' ', 3 )
   source = counter[0]
   if len( counter ) > 3:
      counterName = counter[3].replace( ' ', ',' )
   else:
      counterName = ''
   return ( source, counterName, counter[2] )

def collectorFormatedOutput():
   col = sys.argv[2]
   try:
      output = subprocess.check_output( [ 'python', collectorsPath + col ] )
   except subprocess.CalledProcessError:
      t0( "EventTCollector: Cannot run collector", col )
      print "Cannot run collector", col
      sys.exit( 1 )
   lines = output.splitlines()
   for line in lines:
      source, counterName, val = parseLine( line )
      if counterName:
         print source + '.' +  counterName, val
      else:
         print source, val

def fetchValues():
   col = sys.argv[2]
   try:
      output = subprocess.check_output( [ 'python', collectorsPath + col ] )
   except subprocess.CalledProcessError:
      t0( "EventTCollector: Cannot run collector", col )
      print "Cannot run collector", col
      sys.exit( 1 )
   lines = output.splitlines()
   counters = sys.argv[3:]
   for line in lines:
      source, counterName, val = parseLine( line )
      for counter in counters:
         try:
            source1, counterName1 = counter.rsplit( '.', 1 )
         except ValueError:
            continue
         if not '=' in counterName1:
            counterName1 = ''
            source1 = counter
         if source1 == source and counterName1 == counterName:
            print source, counterName, val
            if len( counters ) == 1:
               sys.exit( 0 )

def initSources( printCounters=False ):
   for col in os.listdir( collectorsPath ):
      if col.endswith( '.py' ):
         try:
            output = subprocess.check_output( [ 'python', collectorsPath + col ] )
         except subprocess.CalledProcessError:
            t0( "EventTCollector: Cannot run collector", col )
            continue
         lines = output.splitlines()
      else:
         continue
      for line in lines:
         source, counterName, _ = parseLine( line )
         source = ( col, source )
         if not source in sources:
            sources[source] = []
         sources[source].append( counterName )

   if printCounters:
      for source in sorted( sources.keys() ):
         for counter in sorted( sources[source] ):
            if counter:
               print source[1] + '.' + counter
            else:
               print source[1]
   else:
      sourcesFile = '/var/run/EventTCollectorSources'
      countersFile = '/var/run/EventTCollectorCounters'
      if len( sys.argv ) == 3:
         sourcesFile += sys.argv[2]
         countersFile += sys.argv[2]
      with open( sourcesFile, 'w' ) as sourceF:
         with open( countersFile, 'w' ) as counterF:
            for source in sorted( sources.keys() ):
               line = source[1] + ' ' + source[0]
               print line
               sourceF.write( line + '\n' )
               for counter in sources[source]:
                  if counter:
                     line = source[1] + ' ' + counter
                  else:
                     line = source[1]
                  counterF.write( line + '\n' )

if __name__ == "__main__":
   argc = len( sys.argv )
   if argc < 2 or sys.argv[1] == 'counters':
      initSources( True )
   elif ( argc == 2 or argc == 3 ) and sys.argv[1] == 'init':
      initSources()
   elif argc == 3 and sys.argv[1] == 'collector':
      collectorFormatedOutput()
   elif argc > 3 and sys.argv[1] == 'get':
      fetchValues()
   else:
      print "Usage:"
      print "  EventTCollector.py"
      print "  EventTCollector.py init"
      print "  EventTCollector.py counters"
      print "  EventTCollector.py collector <collector>"
      print "  EventTCollector.py get <collector> <counter1> <counter2> <...>"
      sys.exit( 1 )
   sys.exit( 0 )
