# Copyright (c) 2006-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This is the top-level Python module for the EthIntf library. It contains some
constants related to frame sizes.
"""

from eunuchs.if_ether_h import ETH_FCS_LEN
from eunuchs.if_vlan_h  import VLAN_ETH_HLEN

MAX_SUPPORTED_FRAME_SIZE = 9236
MAX_SUPPORTED_MTU = MAX_SUPPORTED_FRAME_SIZE - VLAN_ETH_HLEN - ETH_FCS_LEN  # 9214
MAX_MGMT_MTU = 1500 # BUG5808
