#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import TableOutput

def createTableOutput( table, headings ):
   header = TableOutput.Headings( headings )
   # The first column is the cache name, we will left justify that.
   cacheFmt = TableOutput.Format( justify="left", wrap=True )
   fmt = TableOutput.Format( justify="right", maxWidth=12, wrap=True )
   header.formats = [ cacheFmt ] + [ fmt ] * ( len( headings ) - 1 )
   header.doApplyHeaders( table )

def getCacheMessage( cacheName ):
   if cacheName:
      return 'Cache {} does not exist'.format( cacheName )
   return 'No cache servers are configured'

def getCacheUnusedMessage( cacheNames ):
   printedList = ", ".join( sorted( cacheNames ) )
   return "The following caches are not running because too many caches " + \
      "have been configured: " + printedList
