#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

tacErrorType = Tac.Type( "Eoam::ErrorType" )
tacEoamAction = Tac.Type( "Eoam::Action" )
tacEoamInterval = Tac.newInstance( "Eoam::Interval" )
tacIntervalUnit = Tac.Type( "Eoam::IntervalUnit" )

errorTypeToEnumMap = { 'fcs':tacErrorType.errorFcs,
                       'symbol':tacErrorType.errorSymbol }

actionToEnumMap = { 'log' : tacEoamAction.actionLog,
                    'errdisable' : tacEoamAction.actionErrdisable,
                    'linkfault' : tacEoamAction.actionLinkfault }

enumToActionMap = { tacEoamAction.actionLog : 'log',
                    tacEoamAction.actionErrdisable : 'errdisable',
                    tacEoamAction.actionLinkfault : 'linkfault' }

intervalUnitToEnumMap = { 'secs' : tacIntervalUnit.intervalSecs,
                          'frames' : tacIntervalUnit.intervalFrames }

enumToIntervalMap = { tacIntervalUnit.intervalSecs : 'secs',
                      tacIntervalUnit.intervalFrames : 'frames' }
