# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


tempSensorHwStatusStringMap = { 'unknownHwStatus' : 'Unknown',
                                'ok' : 'Ok',
                                'invalidReading' : 'Invalid',
                                'failed' : 'Failed',
                                'disabled' : 'Disabled' }

tempAlarmLevelStringMap = { 'unknownTemperatureAlarmLevel' : 'Unknown',
                            'temperatureOk' : 'Ok',
                            'temperatureOverheating' : 'Overheating',
                            'temperatureSensorFailure' : 'Sensor Failed',
                            'temperatureCritical' : 'Critical' }


coolingAlarmLevelStringMap = { 'unknownCoolingAlarmLevel' : 'Unknown',
                               'coolingOk' : 'Ok',
                               'fanTrayFailedOrMissing' : 'Failed or missing fan',
                               'insufficientFans' : 'Insufficient fans',
                               'incompatibleFans' : 'Incompatible fans' }

airflowDirectionStringMap = { 'unknownAirflowDirection' : 'unknown',
                     'frontToBackAirflow' : 'port-side intake',
                     'backToFrontAirflow' : 'port-side exhaust',
                     'mismatchedAirflow' : 'incompatible fans inserted!' }

fanStatusStringMap = { 'unknownHwStatus' : 'Unknown',
                       'unsupported' : 'Not Supported',
                       'failed' : 'Failed',
                       'powerLoss' : 'Power Loss',
                       'ok' : 'Ok' }

fanTrayStatusStringMap = { 'notInserted' : 'Not Inserted' }
fanTrayStatusStringMap.update( fanStatusStringMap )

def getSensorHwStatusStrings():
   return tempSensorHwStatusStringMap.keys()

def getSensorHwStatusDisplayString( status ):
   assert status in tempSensorHwStatusStringMap
   return tempSensorHwStatusStringMap[ status ]

def getCoolingAlarmLevelStrings():
   return coolingAlarmLevelStringMap.keys()

def getCoolingAlarmLevelDisplayString( level ):
   assert level in coolingAlarmLevelStringMap
   return coolingAlarmLevelStringMap[ level ]

def getAirflowDirectionStrings():
   return airflowDirectionStringMap.keys()

def getAirflowDirectionDisplayString( direction ):
   assert direction in airflowDirectionStringMap
   return airflowDirectionStringMap[ direction ]

def getTempAlarmLevelStrings():
   return tempAlarmLevelStringMap.keys()

def getTempAlarmLevelDisplayString( level ):
   assert level in tempAlarmLevelStringMap
   return tempAlarmLevelStringMap[ level ]

def getFanStatusStrings():
   return fanStatusStringMap.keys()

def getFanStatusDisplayString( status ):
   assert status in fanStatusStringMap
   return fanStatusStringMap[ status ]

def getFanTrayStatusStrings():
   return fanTrayStatusStringMap.keys()

def getFanTrayStatusDisplayString( status ):
   assert status in fanTrayStatusStringMap
   return fanTrayStatusStringMap[ status ]
