#!/usr/bin/env python
# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class EbraTestPortBase( object ):
   def __init__( self, intfName, bridge ):
      self.intfName_ = intfName
      self.bridge_ = bridge

   def close( self ):
      pass

   def name( self ):
      return self.intfName_

   def sendFrame( self, data, srcMacAddr, dstMacAddr, srcPortName,
                  priority, vlanId, vlanAction ):
      raise NotImplementedError

   def trapFrame( self, data ):
      raise NotImplementedError

class EbraTestPortIntfStatusReactor( Tac.Notifiee ):
   notifierTypeName = 'Interface::EthIntfStatus'
   def __init__( self, intfStatus, bridge ):
      Tac.Notifiee.__init__( self, intfStatus )
      self.bridge_ = bridge
      self.handleLinkStatus()

   @Tac.handler( 'linkStatus' )
   def handleLinkStatus( self ):
      if self.notifier_.linkStatus == 'linkDown':
         self.bridge_.macTableFlushPort( self.notifier_.intfId )

class EbraTestPort( EbraTestPortBase ):
   """Common initialization for test ports"""

   # This _is_ an abstract class.
   # pylint: disable-msg=W0223

   def __init__( self, bridge, intfConfig, intfStatus ):
      super( EbraTestPort, self ).__init__( intfStatus.intfId, bridge )
      self.macAddress = '00:00:00:00:00:00'
      self.enabled_ = False

      self.intfStatus_ = None
      self.intfConfig_ = None
      self.intfStatusReactor_ = None
      self.updateStatusConfig( intfStatus, intfConfig )

   def updateStatusConfig( self, intfStatus, intfConfig ):
      self.intfStatus_ = intfStatus
      self.intfConfig_ = intfConfig
      self.intfStatusReactor_ = EbraTestPortIntfStatusReactor(
         intfStatus, self.bridge_ )

   def onActive( self ):
      pass
