#!/usr/bin/env python
# Copyright (c) 2008-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing
from Arnet import PktParserTestLib

handle = Tracing.Handle( 'EbraTestBridge' )
t0 = handle.trace0    #
t2 = handle.trace2    #
t4 = handle.trace4    #
t5 = handle.trace5    #
t6 = handle.trace6    #
t7 = handle.trace7    #
t8 = handle.trace8    #

def decapGrePkt( data, ipHdr, greHdr ):
   # Decap a GRE Packet

   # Remove the IP header and GRE header
   # Inner IP offset is GRE offset plus GRE header size
   innerIpOffset = greHdr.offset + greHdr.greHeaderSize()

   # derive protocol type from gre header
   etherType = data[ ( greHdr.offset + 2 ) : ( greHdr.offset + 4 ) ]

   # Form the new packet, No need to recalculate IP checksum
   newData = data[ 0 : ( ipHdr.offset - 2 ) ] + etherType + data[ innerIpOffset : ]

   return newData

def tunnelHandlePkt( bridge, routed, vlanId, dstMacAddr, data ):

   noMatch = ( None, None )
   config = bridge.tunnelConfig_
   if not config:
      t8( 'tunnelHandlePkt: No config is found for tunnel' )
      return noMatch

   if not config.decapGroup:
      t8( 'tunnelHandlePkt: No decapGroups configured' )
      return noMatch

   packet, headers, _ = PktParserTestLib.parsePktStr( data )
   greHdr = PktParserTestLib.findHeader( headers, 'GreHdr' )
   ipHdr = PktParserTestLib.findHeader( headers, 'IpHdr' )
   ethHdr = PktParserTestLib.findHeader( headers, 'EthHdr' )


   # If we can't find IP header or can't find GRE header, then return noMatch
   if not greHdr or not ipHdr:
      t8( 'tunnelHandlePkt: Can not find IP Hdr and GRE header' )
      return noMatch

   decapGroups = config.decapGroup.keys()
   for key in decapGroups:
      group = config.decapGroup.get( key )
      if group and group.decapIp.keys()[0].v4Addr == ipHdr.dst \
      and group.tunnelType == 'gre':
         t5( 'tunnelHandlePkt: Match found for %s in group %s'
                           % ( group.decapIp, group.name ) )
         break
   else:
      # This for/else branch only runs when we don't hit the break above, which
      # means that we did not match a decap group.
      t8( 'tunnelHandlePkt: No decap group found for ip %s' % ipHdr.dst )
      return noMatch

   # Match is found
   ethHdr.dst = dstMacAddr
   newData = decapGrePkt( packet.stringValue, ipHdr, greHdr )

   t5( 'tunnelHandlePkt decaped %s with %s' % ( ipHdr.dst, dstMacAddr ) )
   return ( newData, dstMacAddr )

def tunnelBridgeInit( bridge ):
   t2( "Tunnel plugin bridgeInit" )
   assert( bridge )
   assert( bridge.em().root() )

   bridge.tunnelConfig_ = Tac.root[ 'tunnel-etba-root' ].dgConfig

def tunnelAgentInit( em ):

   t2( "Tunnel Etba plugin agentInit" )

   mg = em.mountGroup()
   cliDgConfig = mg.mount( "routing/tunneldecap/input/cli",
                           "Tunnel::Decap::ConfigInput", 'r' )
   dgConfigDir = mg.mount( "routing/tunneldecap/input/dynamic", "Tac::Dir", 'r' )

   tunnelEtbaRoot = Tac.root.newEntity( 'Tunnel::TunnelEtbaRoot',
                                        'tunnel-etba-root' )
   tunnelEtbaRoot.dgConfig = ()

   def onMountComplete():
      t2( "Starting DecapGroupConfigMergeSm" )
      tunnelEtbaRoot.dgConfigMergeSm = ( tunnelEtbaRoot.dgConfig,
                                         cliDgConfig,
                                         dgConfigDir,
                                         em.cEntityManager() )


   mg.close( onMountComplete )

def Plugin( ctx ):
   t2( "Vxlan plugin registering" )
   ctx.registerBridgeInitHandler( tunnelBridgeInit )
   ctx.registerAgentInitHandler( tunnelAgentInit )
   ctx.registerTunnelTerminationHandler( tunnelHandlePkt )
