#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell, Tac
from EbraTestBridgePort import EbraTestPort

def Plugin( ctx ):
   ctx.registerInterfaceHandler( 'Interface::SubIntfStatus', EbraTestSubIntf )
   ctx.registerBridgeInitHandler( bridgeInit )
   ctx.registerAgentInitHandler( agentInit )

def agentInit( em ):
   em.mount( "interface/hardware/capability", "Interface::Hardware::Capability", 'w')
   em.mount( 'interface/status/subintf', 'Interface::SubIntfStatusDir', 'r' )
   em.mount( 'interface/hardware/status/subintf',
             'Interface::Hardware::SubIntfStatusDir', 'w' )

def bridgeInit( bridge ):
   bridge.intfHwCapability = \
         bridge.em().entity( 'interface/hardware/capability' )
   bridge.subIntfHwStatusDir = \
         bridge.em().entity( 'interface/hardware/status/subintf' )
   bridge.subIntfStatusDir = \
         bridge.em().entity( 'interface/status/subintf' )

   bridge.subIntfStatusDirReactor = \
                             SubIntfStatusDirReactor( bridge.subIntfStatusDir,
                                                      bridge.subIntfHwStatusDir )

   bridge.agentDirReactor = AgentDirReactor(
                                bridge.em().entity( Cell.path( 'agent/status' ) ),
                                bridge.intfHwCapability )

class SubIntfStatusDirReactor( Tac.Notifiee ):
   notifierTypeName = 'Interface::SubIntfStatusDir'

   def __init__( self, subIntfStatusDir, subIntfHwStatusDir ):
      Tac.Notifiee.__init__( self, subIntfStatusDir )
      self.subIntfHwStatusDir = subIntfHwStatusDir
      self.subIntfStatusDir = subIntfStatusDir
      self.handleSubIntfStatus( None )

   @Tac.handler( 'intfStatus' )
   def handleSubIntfStatus( self, key ):
      if not key:
         for k in self.subIntfStatusDir.intfStatus:
            self.handleSubIntfStatus( k )
      elif key in self.subIntfStatusDir.intfStatus:
         # new subintf create case
         self.subIntfHwStatusDir.newHardwareStatus( key )
         self.subIntfHwStatusDir.hardwareStatus[ key ].hardwareSuccess = True
      else:
         # delete case
         del self.subIntfHwStatusDir.hardwareStatus[ key ]

class AgentDirReactor( Tac.Notifiee ):
   notifierTypeName = 'Tac::Dir'

   def __init__( self, agentDir, intfHwCapability ):
      self.intfHwCapability = intfHwCapability
      Tac.Notifiee.__init__( self, agentDir )
      self.handleAgentDir( None )

   @Tac.handler( 'entryState' )
   def handleAgentDir( self, key ):
      if not key:
         for k in self.notifier_.entryState:
            self.handleAgentDir( k )
      elif key == 'Ebra':
         # This must be a router dut. Enable l3SubintfSupported
         self.intfHwCapability.l3SubintfSupported = True
         # Also enable qinql3SubintfSupported
         self.intfHwCapability.qinql3SubintfSupported = True
         # Also enable both flexEncapVlanXlateSupported and
         # flexEncapVlanXlateFullySupported as namespace DUTs have full support
         # for VLAN translation with FlexEncap
         self.intfHwCapability.flexEncapVlanXlateSupported = True
         self.intfHwCapability.flexEncapVlanXlateFullySupported = True

class EbraTestSubIntf( EbraTestPort ):
   """Simulates a SubIntf."""
   def __init__( self, bridge, tapDevice, trapDevice, intfConfig, intfStatus ):
      EbraTestPort.__init__( self, bridge, intfConfig, intfStatus )
   def close( self ):
      pass
   def processFrame( self, data, srcMacAddr, dstMacAddr, intf, tracePkt ):
      pass
   def sendFrame( self, data, srcMacAddr, dstMacAddr, srcPortName, 
                  priority, vlanId, vlanAction ):
      pass
   def _trapDeviceReadHandler( self, data ):
      pass
   def trapFrame( self, data ):
      pass
