#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import QosLib
from QosTypes import * # pylint: disable-msg=W0401
import Cell

handle = Tracing.Handle( 'EbraTestBridge' )
t2 = handle.trace2

def bridgeInit( bridge ):
   t2( 'Qos bridgeInit' )
   qosHwStatus = bridge.em().entity( 'qos/hardware/status/global' )
   qosAclHwStatus = bridge.em().entity( 'qos/hardware/acl/status/global' )
   qosSliceHwStatusDir = bridge.em().entity(
         Cell.path( 'qos/hardware/status/slice' ) )
   qosHwStatus.numTcSupported = 12
   qosHwStatus.numTxQueueSupported = 8
   qosHwStatus.minPortShapeRate = 100
   qosHwStatus.minTxQueueShapeRate = 20
   qosHwStatus.maxShapeRateKbps = 40000000
   qosHwStatus.maxShapeRatePps = 60000000
   qosHwStatus.defaultTrustMode = 'cos' 
   qosHwStatus.defaultCosSupported = True 
   qosHwStatus.defaultDscpSupported = True 
   qosHwStatus.defaultTcSupported = False 
   qosHwStatus.defaultCos = 5
   qosHwStatus.defaultDscp = 2 
   qosHwStatus.defaultTrafficClass = 6 
   def initArray( array, value ):
      for i in range( len( array ) ):
         array[ i ] = value
   initArray( qosHwStatus.defaultCosToTcMap, 8 )
   initArray( qosHwStatus.defaultDscpToTcMap, 9 )
   initArray( qosHwStatus.defaultTcToCosMap, 3 )
   initArray( qosHwStatus.defaultTcToDscpMap, 5 )
   initArray( qosHwStatus.defaultTcToTxQueueMap, 4 )
   initArray( qosHwStatus.defaultTcToMcTxQueueMap, 4 )

   qosHwStatus.numTxQueueSupported = 12
   qosHwStatus.numMulticastQueueSupported = 4
   qosHwStatus.numUnicastQueueSupported = 8
   qosHwStatus.isSchGroupConfigurable[ 0 ] = True
   qosHwStatus.isSchGroupConfigurable[ 1 ] = False
   mcqid = 0
   ucqid = 0
   for hwtxqid in range( 12 ):
      if ( hwtxqid % 3 ) == 0:
         tacTxQueue.id = mcqid
         tacTxQueue.type = 'mcq'
         mcqid += 1
      else:
         tacTxQueue.id = ucqid
         tacTxQueue.type = 'ucq'
         ucqid += 1
      hwTxQueue = qosHwStatus.cliTxQueueToHwTxQueue.newMember(
         hwtxqid, tacTxQueue, hwtxqid/9 )
      qosHwStatus.hwTxQueue[ hwtxqid ] = hwTxQueue

   qosAclHwStatus.policyQosSupported = True
   qosAclHwStatus.policyQosNumCMapSupported = 20
   qosAclHwStatus.policyQosActionsSupported[ tacActionType.actionSetCos ] = True
   qosAclHwStatus.policyQosActionsSupported[ tacActionType.actionSetDscp ] = True
   qosAclHwStatus.policyQosActionsSupported[ tacActionType.actionSetTc ] = True

   qosHwStatus.coppSupported = True
   qosHwStatus.coppActionShaperSupported = True
   qosHwStatus.coppPpsSupported = True
   qosHwStatus.coppNumCMapSupported = 20
   qosHwStatus.coppPpsSupported = True

   rateUnit = tacRateUnit.rateUnitPps
   
   for qosHwStatus_ in qosSliceHwStatusDir.itervalues():
      qosHwStatus_.coppStaticClass.newMember(
         tacClassMapCpStaticType.cmapCpStaticArp, 25000, 1000, rateUnit, 3 )
      qosHwStatus_.coppStaticClass.newMember(
         tacClassMapCpStaticType.cmapCpStaticBpdu, 6000, 5000, rateUnit, 4 )
      qosHwStatus_.coppStaticClass.newMember(
         tacClassMapCpStaticType.cmapCpStaticDefault, tacActionRateType.noValue,
         tacActionRateType.noValue, rateUnit, 1 )
      qosHwStatus_.coppStaticClass.newMember(
         tacClassMapCpStaticType.cmapCpStaticIgmp, 5000, 4000, rateUnit, 2 )
      qosHwStatus_.coppStaticClass.newMember(
         tacClassMapCpStaticType.cmapCpStaticDrop, 0, 0, rateUnit, 0 )
      qosHwStatus_.pmapType.newMember( QosLib.coppMapType )
      key = Tac.newInstance( "Qos::PolicyMapHwStatusKey", tacDirection.input, 
                             tacPMapNm.coppName )
      coppSystemPolicy = \
          qosHwStatus.pmapType[ QosLib.coppMapType ].pmap.newMember( key )
      classArp = coppSystemPolicy.cmap.newMember( tacCMapNm.coppArp )
      classBpdu = coppSystemPolicy.cmap.newMember( tacCMapNm.coppBpdu )
      classIgmp = coppSystemPolicy.cmap.newMember( tacCMapNm.coppIgmp )
      classDefault = coppSystemPolicy.cmap.newMember( tacCMapNm.coppDefault )
      classDrop = coppSystemPolicy.cmap.newMember( tacCMapNm.coppDrop )
      classBpdu.shapeVal = 5000
      classBpdu.bandwidthVal = 5000
      classArp.shapeVal = 25024
      classArp.bandwidthVal = 1000
      classIgmp.shapeVal = 25024
      classIgmp.bandwidthVal = 1000
      classDrop.shapeVal = tacActionRateType.invalid
      classDrop.bandwidthVal = tacActionRateType.invalid
      classDefault.shapeVal = tacActionRateType.noValue
      classDefault.bandwidthVal = tacActionRateType.noValue

   qosHwStatus.hwInitialized = True
   qosAclHwStatus.hwInitialized = True

def agentInit( em ):
   t2( 'Qos agentInit' )
   em.mount( 'qos/hardware/status/global', 'Qos::HwStatus', 'w' )
   em.mount( 'qos/hardware/acl/status/global', 'Qos::AclHwStatus', 'w' )
   qosSliceHwStatusDirPath = \
         "cell/" + str( Cell.cellId() ) + "/qos/hardware/status/slice"
   em.mount( qosSliceHwStatusDirPath, "Tac::Dir", "wi" )

def Plugin( ctx ):
   ctx.registerBridgeInitHandler( bridgeInit )
   ctx.registerAgentInitHandler( agentInit )
   
