#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing

handle = Tracing.Handle( 'EbraTestBridge' )
t2 = handle.trace2
t8 = handle.trace8

ISIS_ALL_L2_IS = '01:80:c2:00:00:15'
ISIS_ALL_L1_IS = '01:80:c2:00:00:14'
ISIS_ALL_IS = '09:00:2b:00:00:05'
ISIS_ALL_L1_MI_IS = '01:00:5e:90:00:02'
ISIS_ALL_L2_MI_IS = '01:00:5e:90:00:03'
ISIS_MACS = [ ISIS_ALL_L2_IS, ISIS_ALL_L1_IS, ISIS_ALL_IS,
              ISIS_ALL_L1_MI_IS, ISIS_ALL_L2_MI_IS ]

def floodsetIncludesCpu( bridge, vlanId, dstMacAddr, data ):
   t8( 'Received pkt on', vlanId, dstMacAddr)
   if dstMacAddr in ISIS_MACS:
      return True
   return None

def Plugin( ctx ):
   ctx.registerFloodsetIncludesCpuHandler( floodsetIncludesCpu )
