#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell, Tac

def Plugin( ctx ):
   ctx.registerBridgeInitHandler( bridgeInit )
   ctx.registerAgentInitHandler( agentInit )

def agentInit( em ):
   em.mount( 'routing/hardware/status', 'Routing::Hardware::Status', 'w' )
   em.mount( 'routing6/hardware/status', 'Routing6::Hardware::Status', 'w' )
   em.mount( 'arp/hardware/status', 'Arp::Hardware::Status', 'w' )
   em.mount( 'routing/hardware/mpls/capability', 'Mpls::Hardware::Capability', 'w' )

def bridgeInit( bridge ):
   bridge.agentDirReactor_ = AgentDirReactor(
      bridge.em().entity( Cell.path( 'agent/status' ) ),
      bridge.em().entity( 'routing/hardware/status' ),
      bridge.em().entity( 'routing6/hardware/status' ),
      bridge.em().entity( 'arp/hardware/status' ),
      bridge.em().entity( 'routing/hardware/mpls/capability' ) )

class AgentDirReactor( Tac.Notifiee ):
   notifierTypeName = 'Tac::Dir'

   def __init__( self, agentDir, routingHwStatus, routing6HwStatus,
         arpHwStatus, mplsCapability ):
      self.routingHwStatus = routingHwStatus
      self.routing6HwStatus = routing6HwStatus
      self.arpHwStatus = arpHwStatus
      self.mplsCapability = mplsCapability
      Tac.Notifiee.__init__( self, agentDir )
      self.handleAgentDir( None )

   @Tac.handler( 'entryState' )
   def handleAgentDir( self, key ):
      if not key:
         for k in self.notifier_.entryState:
            self.handleAgentDir( k )
         return
      
      if key == 'Ira':
         # This must be a router dut. Enable the "ip routing" and
         # 'ipv6 unicast-routing' commands.
         self.arpHwStatus.arpTableSize = 10240
         self.routingHwStatus.routingSupported = True
         self.routingHwStatus.ucmpSupported = True
         self.routingHwStatus.vrfRoutingSupported = True
         self.routingHwStatus.vrfCapability.maxVrfs = 1024
         self.routingHwStatus.vrfCapability.ipv4EnabledDefault = True
         self.routingHwStatus.vrfCapability.ipv6EnabledDefault = True 
         self.routingHwStatus.srTeCbfSupported = True
         self.routing6HwStatus.routingSupported = True
         self.routing6HwStatus.vrfRoutingSupported = True
         self.routingHwStatus.nexthopGroupSupported = True
         self.routing6HwStatus.ucmpSupported = True
         # publish nexthopGroup type supported by platform
         tacNgType = Tac.Type( 'Routing::NexthopGroup::NexthopGroupType' )
         self.routingHwStatus.nexthopGroupTypeSupported[ tacNgType.ipInIp ] = True
         self.routingHwStatus.maxNexthopGroupEcmp = 512
         self.routingHwStatus.pbrSupported = True
         self.routingHwStatus.pbrFallbackPolicySupported = True
         self.routingHwStatus.fibAckSupported = True
         self.routingHwStatus.orderedEcmpSupported = True
         self.routingHwStatus.staticTunIntfPlatformCapabilityDeclared = True
         # This is a crazy hack, but we're "supporting" MPLS on devices because we
         # run some tests with, e.g. IP DUTs, and want to claim MPLS support, even
         # though there's absolutely no dataplane backing it (Etba is not running).
         self.mplsCapability.mplsSupported = True
         self.mplsCapability.mplsIntfCfgSupported = True
