#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#
# Etba agent plugin to instantiate a routedPortIntfSm
#

import Tac, Tracing, Cell, SharedMem, Smash
from Arnet.NsLib import DEFAULT_NS
from Toggles import EtbaDutToggleLib

handle = Tracing.Handle( 'EbraTestBridge' )
t2 = handle.trace2

entityManager = None

def agentInit( em ):
   t2( "EthIntf agentInit ..." )   
   global entityManager
   entityManager = em
   mg = em.mountGroup()
   mg.mount( Cell.path( "interface/nsconfig" ),
             "Interface::AllIntfNamespaceConfigDir", "r" )

   def onMountComplete():
      t2( "EthIntf agentInit mount complete" )

   mg.close( onMountComplete )
   
def bridgeInit( bridge ):
   t2( "EthIntf bridgeIniting..." )
   
   mngdIntfStatusDir = Tac.newInstance( 'Interface::ManagedIntfStatusDir',
                                        'statusDir' )
   mngdIntfStatusLocalDir = Tac.newInstance( 'Interface::ManagedIntfStatusLocalDir',
                                             'statusLocalDir' )
   # List of EthPhyIntf interfaces for forwarding model resolution
   mngdIntfList = entityManager.getLocalEntity( 'interface/status/managedIntfList' )

   ethPhyIntfStatusDir = bridge.allEthPhyIntfStatusDir_
   cellDir = Cell.root( entityManager.root() )
   nsConfig = cellDir[ 'interface' ][ 'nsconfig' ]

   eisld = bridge.em().entity( Cell.path( 'interface/status/eth/local' ) )
   
   for ethIntfStatus in ethPhyIntfStatusDir.intfStatus.values():
      # Bit of a hack - skip all management interfaces, which are
      # managed by PhyEthtool. This is required for vEOS. On real
      # systems, the hardware driver knows which interfaces it
      # is supposed to managed (from some hardware config tac
      # mode). We could probably use the etba config here, though
      # I don't know if that will have other side effects, so
      # not making that change now. BUG95184 tracks cleaning this
      # up.
      if ethIntfStatus.intfId.startswith( "Management" ):
         continue
      mngdIntfStatusDir.intfStatus.addMember( ethIntfStatus )
      eisl = eisld.intfStatusLocal[ ethIntfStatus.intfId ]
      assert eisl
      mngdIntfStatusLocalDir.intfStatusLocal.addMember( eisl )
      mngdIntfList.intfStatus.addMember( ethIntfStatus )
   shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
   kniStatus = shmemEm.doMount( "kni/ns/%s/status" % DEFAULT_NS,
                                "KernelNetInfo::Status",
                                Smash.mountInfo( 'keyshadow' ) )

   bridge.ethIntfVrfSm = Tac.newInstance( "EthIntf::EthIntfVrfSm",
                                              mngdIntfStatusDir,
                                              nsConfig,
                                              mngdIntfStatusLocalDir,
                                              kniStatus,
                                              False )
   t2( "Created ethIntfVrfSm" )
                                              
def Plugin( ctx ):
   if EtbaDutToggleLib.toggleFastEtbaEnabled():
      # C++ plugin handles this
      return
   ctx.registerAgentInitHandler( agentInit )   
   ctx.registerBridgeInitHandler( bridgeInit )

