#!/usr/bin/env python
# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""Contains common routines for dealing with EbraTestBridge instances
and the kernel interfaces associated with them."""
from EbraTestBridgeLibPythonImpl import * # pylint: disable=wildcard-import
import re
import random
import struct
import Tac
from eunuchs.if_ether_h import ETH_P_8021Q
import sys

def makeTapPam( name, device, hw=None, netNs=None, mtu=None ):
   # TODO netNs
   # TODO mtu (maybe?)
   assert netNs is None
   assert mtu is None
   pam = Tac.newInstance( "Arnet::TapPam", name, device )
   if hw:
      pam.hwAddr = hw
   pam.mode = 'enabled'
   return pam

def fabricDevicePam( dutName, bridgeMac, inNamespace=False ):
   """Create the fabric device for dutName with the specified bridge
   mac address"""
   if inNamespace:
      dev = 'fabric'
   else:
      dev = '%s-fabric' % dutName
   return makeTapPam( "Cpu", dev, hw=bridgeMac )

def tapDevicePam( dutName, intfName ):
   """Create the kernel tap ('et') device for interface
   intfName on dutname"""
   suffix = ethIntfSuffix( intfName )
   if suffix:
      return makeTapPam( intfName, "%s-et%s" % ( dutName, suffix ) )
   return None

def trapDevicePam( dutName, intfName, inNamespace=False, hwAddr=None ):
   """Create the kernel trap ('ed') device for interface
   intfName on dutName.  If we're in a namespace, use the
   'et%d' or 'et%d_%d' name that matches what's used on the hardware."""
   suffix = ethIntfSuffix( intfName )
   if suffix:
      if inNamespace:
         dev = 'et'
      else:
         dev = '%s-ed' % dutName
      dev += suffix
      trapDev = makeTapPam( intfName, dev, hw=hwAddr )
      return trapDev
   elif intfName == 'Cpu':
      if inNamespace:
         dev = 'cpu'
      else:
         dev = '%s-cpu' % dutName
      trapDev = makeTapPam( 'Cpu', dev )
      return trapDev
   else:
      return None

