# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

SwitchportModeAndNativeVlan = Tac.Type( "Bridging::SwitchportModeAndNativeVlan" )
Dot1xConsts = Tac.Type( "Dot1x::Dot1xConstants" )
portControlStr2Enum = { 'auto' : 'controlled',
                        'force-authorized' : 'forceAuth',
                        'force-unauthorized' : 'forceUnauth' }
portControlEnum2Str = { 'controlled' : 'auto',
                        'forceAuth' : 'force-authorized',
                        'forceUnauth' : 'force-unauthorized' }
portStatusEnum2Str = { 'blocked' : 'Unauthorized',
                       'authorized' : 'Authorized',
                       'guestVlan' : 'Authorized(GUEST-VLAN)',
                       'restrictedVlan' : 'Authorized(AUTH-FAIL-VLAN)' }
portStatusStr2Enum = { 'Unauthorized' : 'blocked',
                       'Authorized' : 'authorized',
                       'Authorized(GUEST-VLAN)' : 'guestVlan',
                       'Authorized(AUTH-FAIL-VLAN)' : 'restrictedVlan' }
hostModeStr2Enum = { 'single-host' : 'singleHost',
                     'multi-host' : 'multiHost',
                     'multi-host authenticated' : 'authAllHost' }
hostModeEnum2Str = { 'singleHost' : 'single-host',
                     'multiHost' : 'multi-host',
                     'authAllHost' : 'multi-host authenticated' }

MAX_SUPPLICANT_KEY_SIZE = 128
MAX_SUPPLICANT_ID_SIZE = 128

"""Dot1x Host class encapsulates supplicant information for 802.1x and MBA
supplicants."""
authStageDict = { "idle" : 'IDLE', "authWaitForSupplicant": 'WAIT-FOR-SUPPLICANT',
                  'authWaitForAuthServer' : 'WAIT-FOR-AUTH-SERVER',
                  'reAuthWaitForSupplicant': 'RE-WAIT-FOR-SUPPLICANT',
                  'reAuthWaitForAuthServer': 'RE-WAIT-FOR-AUTH-SERVER',
                  'successfulAuth': 'SUCCESS',
                  'supplicantTimeout': 'SUPPLICANT-TIMEOUT',
                  'authServerTimeout': 'AUTH-SERVER-TIMEOUT',
                  'failedAuth': 'FAILED',
                  'failedUntaggedDynVlan': 'FAILED-DYN-VLAN',
                  'failedTaggedDynVlan': 'FAILED-TAG-DYN-VLAN',
                  'failedInternalVlan': 'FAILED-INTERNAL-VLAN-CONFLICT',
                  'failedAclAttachment': 'FAILED-ACL-ATTACH',
                  'failedDynamicAclCreation': 'FAILED-DYN-ACL-CREATION',
                  'failedStaticAndDynamicAcl': 'FAILED-UNSUPP-STATIC-AND-DYN-ACL',
                  'webAuthStart': 'WEB-AUTH-START',
                  'failedWebAuth': 'WEB-AUTH-FAILED',
                  # TODO: Create separate Log message as part of BUG451606.
                  'failedVlanName': 'FAILED-DYN-VLAN',
                  }

# Shorten few long stages in above dictionary only for CLI outputs
# Adding to authStageDict any new stage same as those in below will have side effects
cliStageShorten = {
      'FAILED-INTERNAL-VLAN-CONFLICT': 'FAILED-VLAN-CONFLICT',
      'FAILED-UNSUPP-STATIC-AND-DYN-ACL': 'FAILED-UNSUPP-ACL',
}

authMethodDict = {
      "eapol" : "EAPOL",
      "mba" : "MAC-BASED-AUTH"
      }
