#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import re

# cache value after 1st read, so we don't read prefdl each time!
ourPCA = None

def getPCA( ):
   global ourPCA
   if ourPCA == None:
      prefdl = Tac.run(["/bin/sh", "-c",
                        "/usr/bin/idseeprom --device=1.0x52 read" \
                        " |  prefdl --decode -"], stdout=Tac.CAPTURE)
      pf = prefdl.splitlines( )
      for line in pf:
         if line.startswith('PCA: '):
            m = re.match('PCA: *(PCA[0-9]+)', line)
            ourPCA = m.group(1)
            break
      if ourPCA == None:
         ourPCA = 'Unable to read PCA'
   return ourPCA

def getBasePCA( ):
   return getPCA( )[0:8]
