# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ark
from TableOutput import createTable, Format

def createDhcpSnoopingCountersTable( outputHeader, counterModel ):
   output = []
   for vlan in sorted( counterModel.vlanCounters.keys() ):
      vlanCounters = counterModel.vlanCounters[ vlan ]
      output.append( [ vlanCounters.vlan, vlanCounters.requestsReceived,
                       vlanCounters.requestsForwarded,
                       vlanCounters.requestsDropped,
                       vlanCounters.repliesReceived, 
                       vlanCounters.repliesForwarded,
                       vlanCounters.repliesDropped,
                       Ark.utcTimeRelativeToNowStr( vlanCounters.resetTime ) ] )
   outputTable = createTable( outputHeader )
   for row in output:
      outputTable.newRow( *row )
   f1 = Format( justify='right', border=True )
   f2 = Format( justify='right' )
   f1.padLimitIs( True )
   f2.padLimitIs( True )
   outputTable.formatColumns( f1, f2, f2, f1, f2, f2, f1, f2 )
   return outputTable

