#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from IpLibConsts import DEFAULT_VRF
from IpUtils import compareIpAddress, compareIp6Address

def compareIpAddrVrf( x, y ):
   if x.vrfName == DEFAULT_VRF and y.vrfName != DEFAULT_VRF:
      return -1
   elif x.vrfName != DEFAULT_VRF and y.vrfName == DEFAULT_VRF:
      return 1
   elif x.vrfName < y.vrfName:
      return -1
   elif x.vrfName > y.vrfName:
      return 1
   else:
      return compareIpAddress( x.ip.v4Addr, y.ip.v4Addr )

def compareIpv6AddrVrf( x, y ):
   if x.vrfName == DEFAULT_VRF and y.vrfName != DEFAULT_VRF:
      return -1
   elif x.vrfName != DEFAULT_VRF and y.vrfName == DEFAULT_VRF:
      return 1 
   elif x.vrfName < y.vrfName:
      return -1
   elif x.vrfName > y.vrfName:
      return 1
   else:
      return compareIp6Address( x.ip.v6Addr, y.ip.v6Addr )

def compareHostnameVrf( x, y ):
   if x.vrfName == DEFAULT_VRF and y.vrfName != DEFAULT_VRF:
      return -1
   elif x.vrfName != DEFAULT_VRF and y.vrfName == DEFAULT_VRF:
      return 1
   elif x.vrfName < y.vrfName:
      return -1
   elif x.vrfName > y.vrfName:
      return 1
   elif x.hostname < y.hostname:
      return -1
   else:
      return 1
