#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re

def kernelIntfToEosIntf( intf ):
   return intf.replace( 'vlan', 'Vlan' ).replace( 'et', 'Ethernet' ). \
                   replace( 'po', 'Port-Channel' ).replace( '_', '/' ). \
                   replace( 'lo', 'Loopback' ).replace( 'tu', 'Tunnel' ). \
                   replace( 'ma', 'Management' )

def eosIntfToKernelIntf( intf ):
   return intf.replace( 'Vlan', 'vlan' ).replace( 'Ethernet', 'et' ). \
                   replace( 'Port-Channel', 'po' ).replace( '/', '_' ). \
                   replace( 'Loopback', 'lo' ).replace( 'Tunnel', 'tu' ). \
                   replace( 'Management', 'ma' )

def fixKernelIntf( m ):
   # replace kernel interface name by EOS interface name
   s = m.group()
   # We're passed trailing whitespace so that we can try to adjust the
   # whitespace along with the string.
   origLen = len( s )
   ret = s.rstrip()
   hadWhitespace = ( s != ret )
   ret = kernelIntfToEosIntf( ret )
   if hadWhitespace:
      if len( ret ) < origLen:
         ret += " " * ( origLen - len( ret ) )
      else:
         # We are returning a longer string, but at least give it one space.
         ret += " "
   return ret

def kernelIntfFilter( out ):
   out = re.sub( r'\b((?:vlan|et|po|lo|tu|ma)[0-9_]+) *\b', fixKernelIntf, out )
   return out

