# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entMan ):
   SERVICE_NAME = "VirtualNetwork"
   controllerVersions = ( ( 1, 'First version of %s service' % SERVICE_NAME ), )
   addServiceInfo( entMan.serviceCtx_, SERVICE_NAME, controllerVersions,
                   enabled=True )
   addServiceInfo( entMan.serviceClientCtx_, SERVICE_NAME, controllerVersions,
                   enabled=True )
