# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Tac
from TypeFuture import TacLazyType

systemTunnelRibName = TacLazyType( "Tunnel::TunnelTable::TunnelRibNameIdMap"
                              ).systemTunnelRibName
systemTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                            ).systemTunnelRibId
systemColoredTunnelRibName = TacLazyType( "Tunnel::TunnelTable::TunnelRibNameIdMap"
                                     ).systemColoredTunnelRibName
systemColoredTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                                   ).systemColoredTunnelRibId
systemTunnelingLdpTunnelRibName = TacLazyType( 
      "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemTunnelingLdpTunnelRibName
systemTunnelingLdpTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                            ).systemTunnelingLdpTunnelRibId
systemIgpShortcutTunnelRibName = TacLazyType( 
      "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemIgpShortcutTunnelRibName
systemIgpShortcutTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                                   ).systemIgpShortcutTunnelRibId
TunnelTableIdentifier = TacLazyType( "Tunnel::TunnelTable::TunnelTableIdentifier" )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "TUNNEL" )
   tunnelRibsConfig = entMan.root()[ "tunnel" ][ "tunnelRibs" ][ "config" ]
   systemTunnelRibConfig = tunnelRibsConfig.config.get( systemTunnelRibName )
   if not systemTunnelRibConfig:
      systemTunnelRibConfig = tunnelRibsConfig.config.newMember(
         systemTunnelRibName )
   tunnelTables = ( TunnelTableIdentifier.bgpLuTunnelTable,
                    TunnelTableIdentifier.srTunnelTable,
                    TunnelTableIdentifier.ldpTunnelTable,
                    TunnelTableIdentifier.rsvpLerTunnelTable,
                    TunnelTableIdentifier.nexthopGroupTunnelTable,
                    TunnelTableIdentifier.staticTunnelTable )
   ProtoPrefAction = Tac.Type( "Tunnel::TunnelTable::ProtoPrefAction" )
   prefMapping = Tac.Value( "Tunnel::TunnelTable::ProtoPrefMapping",
                            ProtoPrefAction.prefDefault, 0 )

   for tunnelTable in tunnelTables:
      if tunnelTable not in systemTunnelRibConfig.entry:
         systemTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                prefMapping )
   for tunnelTable in systemTunnelRibConfig.entry.keys():
      if tunnelTable not in tunnelTables:
         del systemTunnelRibConfig.entry[ tunnelTable ]

   systemColoredTunnelRibConfig = tunnelRibsConfig.config.get(
      systemColoredTunnelRibName )
   if not systemColoredTunnelRibConfig:
      systemColoredTunnelRibConfig = tunnelRibsConfig.config.newMember(
         systemColoredTunnelRibName )
   tunnelTables = [ TunnelTableIdentifier.srTePolicyTunnelTable ]
   for tunnelTable in tunnelTables:
      if tunnelTable not in systemColoredTunnelRibConfig.entry:
         systemColoredTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                       prefMapping )
   for tunnelTable in systemColoredTunnelRibConfig.entry.keys():
      if tunnelTable not in tunnelTables:
         del systemColoredTunnelRibConfig.entry[ tunnelTable ]

   for tunnelRibName in [ systemTunnelingLdpTunnelRibName, 
                          systemIgpShortcutTunnelRibName ]:
      appTunnelRibConfig = tunnelRibsConfig.config.get( tunnelRibName )
      if not appTunnelRibConfig:
         appTunnelRibConfig = tunnelRibsConfig.config.newMember( tunnelRibName )
      tunnelTables = [ TunnelTableIdentifier.rsvpLerTunnelTable ]
      for tunnelTable in tunnelTables:
         if tunnelTable not in appTunnelRibConfig.entry:
            appTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                prefMapping )
      for tunnelTable in appTunnelRibConfig.entry.keys():
         if tunnelTable not in tunnelTables:
            del appTunnelRibConfig.entry[ tunnelTable ]

   # Populate systemTunnelRib and systemColoredTunnelRib names and IDs
   tunnelRibNameIdMap = entMan.root().entity[
      "tunnel/tunnelRibs/tunnelRibNameIdMap" ]
   tunnelRibNameIdMap.nameToId[ systemTunnelRibName ] = systemTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemColoredTunnelRibName ] = \
                                                  systemColoredTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemTunnelingLdpTunnelRibName ] = \
                                                  systemTunnelingLdpTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemIgpShortcutTunnelRibName ] = \
                                                  systemIgpShortcutTunnelRibId

   # Start currentId just past the last system id
   tunnelRibNameIdMap.currentId = systemIgpShortcutTunnelRibId + 1
