# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
# pylint: disable-msg=W0612
import SysdbUtil
import Tracing
import QosLib

t0 = Tracing.trace0

def createDefaultConfigPdp( cliCfg, aclCfg ):
   # PDP built in classes
   QosLib.createBuiltInClasses( aclCfg )

_createDefaultConfigCallback = {}
# Registration of callbacks for createDefaultConfig
_createDefaultConfigCallback[ QosLib.pdpMapType ] = createDefaultConfigPdp

def _createDefaultConfig( cliCfg, aclCfg ):
   t0( "creating Default Config" )
   QosLib.createPMapAndCMapTypes( aclCfg )
   for cb in _createDefaultConfigCallback.itervalues():
      cb( cliCfg, aclCfg )

def Plugin( entMan ):

   SysdbUtil.addLogFacility( entMan, "QOS" )

   aclCfg = entMan.lookup( "qos/acl/input/cli" )
   cliConfig = entMan.lookup( "qos/input/config/cli" )
   fabricIntfConfigDir = entMan.lookup( "qos/fabric/config" )
   profileConfig = entMan.lookup( "qos/input/config/qosProfile" )

   aclCfg.configPriority = 100
   cliConfig.agentName = 'Cli'
   cliConfig.configPriority = 100
   cliConfig.intfConfigPriority = 100
   fabricIntfConfigDir.intfConfig.newMember( 'Fabric0/255' )
   profileConfig.agentName = 'Cli'
   profileConfig.configPriority = 95
   profileConfig.intfConfigPriority = 95

   _createDefaultConfig( cliConfig, aclCfg )
