# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import DefaultConfigPlugin.HttpService
from ServicePluginContext import addServiceInfo

CVX_SERVICE_NAME = 'Pcs'
HTTP_SERVICE_NAME = 'pcs'
@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config',
                            'mgmt/capi/config' ) )
def Plugin( em ):
   controllerVersions = ( ( 1, 'Birth of Policy Control service' ), )
   addServiceInfo( em.serviceCtx_, CVX_SERVICE_NAME, controllerVersions )
   # There's no CLI for enabling Pcs service on the switch-side. So, it should
   # be enabled by default
   addServiceInfo( em.serviceClientCtx_, CVX_SERVICE_NAME, controllerVersions,
                   enabled=True )
   DefaultConfigPlugin.HttpService.registerHttpServiceConfig(
         em, HTTP_SERVICE_NAME, serviceName="%s web service" % HTTP_SERVICE_NAME )
